/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui.selection;

import com.frinika.project.ProjectContainer;
import com.frinika.sequencer.gui.selection.SelectionFocusable;
import com.frinika.sequencer.gui.selection.SelectionListener;
import com.frinika.sequencer.model.Selectable;
import java.util.Collection;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SelectionContainer<T extends Selectable>
implements SelectionFocusable {
    private long selectionStartTick = -1L;
    private int selectionLeftColumn;
    protected T focus = null;
    Vector<T> selectedList = new Vector();
    Vector<SelectionListener<T>> selectionListeners = new Vector();
    ProjectContainer project;
    boolean dirty = false;

    public SelectionContainer(ProjectContainer project) {
        this.project = project;
    }

    public void addSelected(T item) {
        this.selectedList.add(item);
        item.setSelected(true);
        Vector<T> list = new Vector<T>();
        list.add(item);
        this.setFocus(item);
        this.project.setSelectionFocus(this);
        this.dirty = true;
    }

    public void addSelected(Collection<? extends T> list) {
        this.selectedList.addAll(list);
        for (Selectable item : list) {
            item.setSelected(true);
        }
        if (list.size() != 0) {
            this.focus = (Selectable)list.iterator().next();
        }
        this.project.setSelectionFocus(this);
        this.dirty = true;
    }

    public void setSelected(T item) {
        Vector<T> list = new Vector<T>();
        list.add(item);
        this.setSelected((Collection<? extends T>)list);
    }

    public void setSelected(Collection<? extends T> list) {
        for (Selectable t : this.selectedList) {
            t.setSelected(false);
        }
        this.selectedList.removeAllElements();
        this.selectionStartTick = -1L;
        this.focus = null;
        for (Selectable item : list) {
            item.setSelected(true);
        }
        this.selectedList.addAll(list);
        if (list.size() != 0) {
            this.focus = (Selectable)list.iterator().next();
            this.setFocus(this.focus);
        }
        this.project.setSelectionFocus(this);
        this.dirty = true;
    }

    public void setSelectedX(Collection<Selectable> list) {
        for (Selectable t : this.selectedList) {
            t.setSelected(false);
        }
        this.selectedList.removeAllElements();
        this.selectionStartTick = -1L;
        this.focus = null;
        for (Selectable item : list) {
            item.setSelected(true);
        }
        this.selectedList.addAll(list);
        if (list.size() != 0) {
            this.focus = list.iterator().next();
            this.setFocus(this.focus);
        }
        this.project.setSelectionFocus(this);
        this.dirty = true;
    }

    public void removeSelected(T item) {
        if (item == this.focus) {
            this.focus = null;
        }
        this.selectedList.remove(item);
        item.setSelected(false);
        Vector<T> list = new Vector<T>();
        list.add(item);
        this.dirty = true;
    }

    public void removeSelected(Collection<? extends T> list) {
        if (list.contains(this.focus)) {
            this.focus = null;
        }
        this.selectedList.removeAll(list);
        for (Selectable item : list) {
            item.setSelected(false);
        }
        this.dirty = true;
    }

    @Override
    public void clearSelection() {
        this.focus = null;
        this.selectionStartTick = -1L;
        for (Selectable t : this.selectedList) {
            t.setSelected(false);
        }
        this.selectedList.clear();
        this.dirty = true;
    }

    public long getSelectionStartTick() {
        return this.selectionStartTick;
    }

    public void setSelectionStartTick(long selectionStartTick) {
        this.selectionStartTick = selectionStartTick;
        this.dirty = true;
    }

    public Collection<T> getSelected() {
        return this.selectedList;
    }

    @Override
    public Collection<Selectable> getObjects() {
        return this.selectedList;
    }

    public void addSelectionListener(SelectionListener<T> listener) {
        this.selectionListeners.add(listener);
    }

    public void removeSelectionListener(SelectionListener<T> listener) {
        this.selectionListeners.remove(listener);
    }

    public T getFocus() {
        return this.focus;
    }

    protected abstract void setMetaFocus();

    public void setFocus(T focus) {
        if (focus == this.focus && this.project.getSelectionFocus() == this) {
            return;
        }
        this.focus = focus;
        this.setMetaFocus();
        this.project.setSelectionFocus(this);
        this.dirty = true;
    }

    public void notifyListeners() {
        if (!this.dirty) {
            return;
        }
        for (SelectionListener<T> selectionListener : this.selectionListeners) {
            selectionListener.selectionChanged(this);
        }
        this.dirty = false;
    }

    public void setSelectionLeftColumn(int selectionLeftColumn) {
        this.selectionLeftColumn = selectionLeftColumn;
        this.dirty = true;
    }

    public int getSelectionLeftColumn() {
        return this.selectionLeftColumn;
    }

    public void setDirty() {
        this.dirty = true;
    }
}

