/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui.pianoroll;

import com.frinika.gui.util.ButtonFactory;
import com.frinika.localization.CurrentLocale;
import com.frinika.project.ProjectContainer;
import com.frinika.project.gui.ProjectFrame;
import com.frinika.sequencer.gui.ItemPanel;
import com.frinika.sequencer.gui.ItemRollToolBar;
import com.frinika.sequencer.gui.ItemScrollPane;
import com.frinika.sequencer.gui.Layout;
import com.frinika.sequencer.gui.ListProvider;
import com.frinika.sequencer.gui.PopupClient;
import com.frinika.sequencer.gui.PopupSelectorButton;
import com.frinika.sequencer.gui.pianoroll.ControllerHandle;
import com.frinika.sequencer.gui.pianoroll.ControllerView;
import com.frinika.sequencer.gui.pianoroll.MultiEventEditPanel;
import com.frinika.sequencer.gui.pianoroll.PadPanel;
import com.frinika.sequencer.gui.pianoroll.PianoRoll;
import com.frinika.sequencer.gui.pianoroll.WarpToPartLeftAction;
import com.frinika.sequencer.gui.selection.SelectionContainer;
import com.frinika.sequencer.gui.selection.SelectionListener;
import com.frinika.sequencer.model.Lane;
import com.frinika.sequencer.model.MidiLane;
import com.frinika.sequencer.model.Part;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.Collection;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PianoControllerSplitPane
extends ItemScrollPane
implements ComponentListener,
SelectionListener<Lane> {
    private static final long serialVersionUID = 1L;
    JSplitPane splitPane;
    JPanel bot = new JPanel();
    ControllerView cntrlView;
    ControllerHandle[] cntrls;
    private JPopupMenu cntrlPopup;
    PopupSelectorButton cntrlBut;
    ProjectFrame frame;
    PadPanel pianoHeader;
    public PianoRoll pianoRoll;
    MultiEventEditPanel noteEditPanel;

    public PianoControllerSplitPane(ProjectFrame frame) {
        this.frame = frame;
        this.cntrlView = new ControllerView(frame, this);
        this.pianoRoll = new PianoRoll(frame, this);
        Vector<ItemPanel> clients = new Vector<ItemPanel>();
        clients.add(this.pianoRoll);
        clients.add(this.cntrlView);
        final ProjectContainer project = frame.getProjectContainer();
        ItemRollToolBar toolBar = new ItemRollToolBar(clients, project);
        this.noteEditPanel = new MultiEventEditPanel(project);
        project.getDragList().addFeedbackItemListener(this.noteEditPanel);
        project.getEditHistoryContainer().addEditHistoryListener(this.noteEditPanel);
        project.getMultiEventSelection().addSelectionListener(this.noteEditPanel);
        toolBar.add(this.noteEditPanel);
        Insets insets = new Insets(0, 0, 0, 0);
        final WarpToPartLeftAction wpl = new WarpToPartLeftAction(project, this.pianoRoll);
        ButtonFactory.makePressButton("viewpageleft", "warptopartleft", CurrentLocale.getMessage("sequencer.pianoroll.warptopartleft_tip"), wpl, toolBar.getZoomPanel()).setMargin(insets);
        final JToggleButton bb = ButtonFactory.makeToggleButton("music_drumnote", "music_drumnote", CurrentLocale.getMessage("sequencer.pianoroll.drumwrite_tip"), wpl, toolBar.getToolsPanel());
        bb.setMargin(insets);
        bb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PianoControllerSplitPane.this.pianoRoll.setDrumWriteMode(bb.isSelected());
            }
        });
        SelectionListener listener = new SelectionListener(){
            Part focusOld = null;

            public void selectionCleared(SelectionContainer src) {
            }

            public void addedToSelection(SelectionContainer src, Collection items) {
            }

            public void removedFromSelection(SelectionContainer src, Collection items) {
            }

            public void selectionChanged(SelectionContainer src) {
                Part newFocus = (Part)project.getPartSelection().getFocus();
                if (this.focusOld == newFocus) {
                    return;
                }
                if (newFocus != null) {
                    wpl.actionPerformed(null);
                }
                this.focusOld = newFocus;
            }
        };
        this.pianoRoll.setToolBar(toolBar);
        this.cntrlView.setToolBar(toolBar);
        this.setView(this.pianoRoll);
        JPanel top = new JPanel(new BorderLayout());
        top.setDoubleBuffered(false);
        top.add((Component)this.pianoRoll, "Center");
        this.setToolBar(toolBar);
        this.pianoHeader = new PadPanel(this.pianoRoll, Layout.timePanelHeight, this.vertScroll.getValue());
        project.getPartSelection().addSelectionListener(this.pianoHeader);
        top.add((Component)this.pianoHeader, "West");
        this.bot.setLayout(null);
        ListProvider resource = new ListProvider(){

            public Object[] getList() {
                Lane lane = (Lane)project.getLaneSelection().getFocus();
                if (lane instanceof MidiLane) {
                    return ((MidiLane)lane).getControllerList().getList();
                }
                return null;
            }
        };
        PopupClient client = new PopupClient(){

            public void fireSelected(PopupSelectorButton but, Object o, int pos) {
                Lane lane = (Lane)project.getLaneSelection().getFocus();
                if (lane instanceof MidiLane) {
                    PianoControllerSplitPane.this.cntrlView.setControllerType((ControllerHandle)o);
                }
            }
        };
        this.cntrlBut = new PopupSelectorButton(resource, client);
        this.cntrlBut.setBounds(0, 0, this.pianoHeader.getWidth(), 20);
        this.bot.add(this.cntrlBut);
        this.cntrlBut.setLocation(0, 0);
        this.cntrlBut.setLayout(null);
        this.cntrlBut.label.setBounds(0, 0, this.pianoHeader.getWidth(), 20);
        this.cntrlBut.validate();
        this.splitPane = new JSplitPane(0);
        this.splitPane.setDoubleBuffered(false);
        this.splitPane.add((Component)top, "top");
        this.bot.add(this.cntrlView);
        this.splitPane.setResizeWeight(0.8);
        this.splitPane.add((Component)this.bot, "bottom");
        this.pianoRoll.addComponentListener(this);
        this.bot.addComponentListener(this);
        this.add(this.splitPane);
        this.validate();
        this.horizScroll.setModel(this.pianoRoll.getXRangeModel());
        this.vertScroll.addAdjustmentListener(this.pianoHeader);
        this.horizScroll.addAdjustmentListener(this.cntrlView);
        this.vertScroll.setModel(this.pianoRoll.getYRangeModel());
        project.getLaneSelection().addSelectionListener(this);
        this.rebuild();
    }

    @Override
    protected void rebuild() {
        int maxY = 128 * Layout.getNoteItemHeight();
        this.pianoRoll.getYRangeModel().setMaximum(maxY);
        this.itemPanel.setDirty();
        this.itemPanel.repaint();
        this.pianoHeader.repaint();
    }

    public void rightButtonPressed(int x, int y) {
        this.cntrlPopup.show(this, x, y);
    }

    public void dispose() {
        this.pianoRoll.removeComponentListener(this);
        this.bot.removeComponentListener(this);
        this.frame.getProjectContainer().getLaneSelection().removeSelectionListener(this);
        this.frame.getProjectContainer().getDragList().removeFeedbackItemListener(this.noteEditPanel);
        this.frame.getProjectContainer().getEditHistoryContainer().removeEditHistoryListener(this.noteEditPanel);
        this.frame.getProjectContainer().getMultiEventSelection().removeSelectionListener(this.noteEditPanel);
    }

    @Override
    public void componentResized(ComponentEvent e) {
        Rectangle rect = this.pianoRoll.getBounds();
        rect.height = this.bot.getHeight();
        rect.y = 0;
        this.cntrlView.setBounds(rect);
        this.bot.validate();
        this.bot.repaint();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    public PianoRoll createPianoRoll(ProjectContainer project) {
        return this.pianoRoll;
    }

    @Override
    public void selectionChanged(SelectionContainer<? extends Lane> src) {
        Lane lane = src.getFocus();
        if (lane instanceof MidiLane) {
            this.cntrlView.setControllerType((ControllerHandle)((MidiLane)lane).getControllerList().getList()[0]);
        }
    }

    public PianoRoll getPianoRoll() {
        return this.pianoRoll;
    }

    public ControllerView getControllerView() {
        return this.cntrlView;
    }

    @Override
    protected void vertZoom(int inc) {
        Layout.noteHeightIndex += inc;
        Layout.noteHeightIndex = Math.min(Layout.noteHeightIndex, Layout.noteItemHeights.length - 1);
        Layout.noteHeightIndex = Math.max(Layout.noteHeightIndex, 0);
    }
}

