/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui.pianoroll;

import com.frinika.project.ProjectContainer;
import com.frinika.sequencer.model.MidiLane;
import com.frinika.sequencer.model.MidiPart;
import com.frinika.sequencer.model.NoteEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.swing.Timer;

public class AudioFeedBack
implements ActionListener {
    NoteEvent ev = null;
    Receiver recv = null;
    private int chan;
    private int pitch;
    Timer timer;
    ProjectContainer project;

    public AudioFeedBack(ProjectContainer project) {
        this.project = project;
        this.timer = new Timer(0, this);
        this.timer.setRepeats(false);
    }

    public void select(NoteEvent ev) {
        this.off();
        this.ev = ev;
        this.on();
    }

    public void on() {
        MidiPart part = this.ev.getPart();
        MidiLane lane = (MidiLane)part.getLane();
        this.recv = lane.getReceiver();
        if (this.recv == null) {
            return;
        }
        this.chan = lane.getMidiChannel();
        this.pitch = this.ev.getNote();
        ShortMessage shm = new ShortMessage();
        try {
            shm.setMessage(144, this.chan, lane.mapNote(this.pitch), this.ev.getVelocity());
        }
        catch (InvalidMidiDataException e) {
            e.printStackTrace();
        }
        this.recv.send(shm, -1L);
        int millis = (int)(60000.0 * (double)this.ev.getDuration() / (double)this.project.getSequence().getResolution() / (double)this.project.getSequencer().getTempoInBPM());
        this.timer.setInitialDelay(millis);
        this.timer.restart();
    }

    public void off() {
        this.timer.stop();
        if (this.recv == null) {
            return;
        }
        ShortMessage shm = new ShortMessage();
        MidiPart part = this.ev.getPart();
        MidiLane lane = (MidiLane)part.getLane();
        try {
            shm.setMessage(144, this.chan, lane.mapNote(this.pitch), 0);
        }
        catch (InvalidMidiDataException e) {
            e.printStackTrace();
        }
        this.recv.send(shm, -1L);
        this.recv = null;
    }

    public void actionPerformed(ActionEvent arg0) {
        this.off();
    }
}

