/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui.partview;

import com.frinika.project.gui.ProjectFrame;
import com.frinika.sequencer.patchname.MyPatch;
import com.frinika.sequencer.patchname.Node;
import com.frinika.sequencer.patchname.PatchNameMap;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VoiceTree
extends JTree {
    private static Icon instrument_icon = new ImageIcon(ProjectFrame.class.getResource("/icons/instrument.gif"));
    HashMap patchlist = new HashMap();

    public VoiceTree(PatchNameMap vl) {
        this.setModel(new DefaultTreeModel(this.myTreeRoot(vl)));
        this.setRootVisible(true);
        this.jbInit();
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
        renderer.setLeafIcon(instrument_icon);
        this.setCellRenderer(renderer);
    }

    public void select(MyPatch patch) {
        DefaultMutableTreeNode treenode = (DefaultMutableTreeNode)this.patchlist.get(patch);
        if (treenode == null) {
            return;
        }
        TreePath path = new TreePath(treenode.getPath());
        this.setSelectionPath(path);
        Rectangle bounds = this.getPathBounds(path);
        this.scrollRectToVisible(bounds);
    }

    public void jbInit() {
        this.setMinimumSize(new Dimension(0, 0));
    }

    private void addNodes(DefaultMutableTreeNode tn, Vector<Node> list) {
        for (Node o : list) {
            DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(o);
            if (o.getData() instanceof MyPatch) {
                this.patchlist.put(o.getData(), newNode);
            }
            tn.add(newNode);
            if (!(o.getData() instanceof Vector)) continue;
            this.addNodes(newNode, (Vector)o.getData());
        }
    }

    private DefaultMutableTreeNode myTreeRoot(PatchNameMap vl) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Instruments");
        this.addNodes(root, vl.getList());
        return root;
    }
}

