/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui.partview;

import com.frinika.global.FrinikaConfig;
import com.frinika.localization.CurrentLocale;
import com.frinika.project.MidiDeviceDescriptor;
import com.frinika.project.SynthesizerDescriptor;
import com.frinika.sequencer.gui.mixer.SynthWrapper;
import com.frinika.sequencer.gui.partview.LaneView;
import com.frinika.sequencer.model.Lane;
import com.frinika.sequencer.model.SynthLane;
import com.frinika.synth.importers.soundfont.SoundFontFileFilter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.lang.reflect.Method;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class SynthLaneView
extends LaneView {
    private static final long serialVersionUID = 1L;
    SynthLane synthlane;
    MidiDeviceDescriptor midiDescriptor;
    MidiDevice midiDevice;
    MidiDevice realDevice;
    SynthWrapper synthWrapper = null;
    MidiDevice.Info deviceInfo;

    public SynthLaneView(Lane lane) {
        super(lane);
        this.synthlane = (SynthLane)lane;
        this.midiDescriptor = this.synthlane.getMidiDescriptor();
        this.midiDevice = this.midiDescriptor.getMidiDevice();
        if (this.midiDevice instanceof SynthWrapper) {
            this.synthWrapper = (SynthWrapper)this.midiDevice;
            this.realDevice = this.synthWrapper.getRealDevice();
        } else {
            this.realDevice = this.midiDevice;
        }
        this.deviceInfo = this.realDevice.getDeviceInfo();
        this.init();
    }

    void makeHeader() {
        GridBagConstraints gc2 = (GridBagConstraints)this.gc.clone();
        gc2.gridwidth = 0;
        gc2.insets = new Insets(0, 0, 0, 0);
        gc2.fill = 2;
        JPanel panel = new JPanel();
        JLabel label = new JLabel(this.midiDescriptor.getIcon());
        label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 7));
        panel.add(label);
        panel.setBorder(BorderFactory.createEmptyBorder(7, 5, 7, 5));
        panel.setLayout(new BoxLayout(panel, 0));
        panel.setBackground(Color.WHITE);
        label = new JLabel("<html><body><b>" + this.deviceInfo.getName() + "</b><br>" + this.deviceInfo.getVendor() + " <font color='#A0A0A0'><i>" + this.deviceInfo.getVersion() + "</i></font></body></html>");
        label.setFont(label.getFont().deriveFont(0));
        panel.add(label);
        this.add((Component)panel, gc2);
        JSeparator sep = new JSeparator(0);
        sep.setMinimumSize(new Dimension(5, 5));
        this.add((Component)sep, gc2);
    }

    protected void makeButtons() {
        this.makeHeader();
        this.gc.insets = new Insets(5, 5, 5, 5);
        if (this.synthWrapper != null && this.realDevice instanceof Synthesizer) {
            JButton loadSoundbankButton = new JButton(CurrentLocale.getMessage("mididevices.loadsoundbank"));
            loadSoundbankButton.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    try {
                        JFileChooser chooser = new JFileChooser(FrinikaConfig.SOUNDFONT_DIRECTORY);
                        chooser.setDialogTitle("Open soundfont");
                        chooser.setFileFilter(new SoundFontFileFilter());
                        if (chooser.showOpenDialog(null) == 0) {
                            File soundFontFile = chooser.getSelectedFile();
                            Soundbank soundbank = SynthLaneView.this.synthWrapper.getSoundbank(soundFontFile);
                            SynthLaneView.this.synthWrapper.loadAllInstruments(soundbank);
                            System.out.println("Soundbank loaded");
                            ((SynthesizerDescriptor)SynthLaneView.this.midiDescriptor).setSoundBankFileName(soundFontFile.getAbsolutePath());
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
            this.add((Component)loadSoundbankButton, this.gc);
            MidiDevice dev = this.synthWrapper.getRealDevice();
            try {
                Method method = dev.getClass().getMethod("show", new Class[0]);
                JButton showSettingsButton = new JButton(CurrentLocale.getMessage("mididevices.show"));
                showSettingsButton.addMouseListener(new MouseAdapter(){

                    public void mouseClicked(MouseEvent e) {
                        MidiDevice dev = SynthLaneView.this.synthWrapper.getRealDevice();
                        try {
                            Method method = dev.getClass().getMethod("show", new Class[0]);
                            method.invoke((Object)dev, new Object[0]);
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                    }
                });
                this.add((Component)showSettingsButton, this.gc);
            }
            catch (SecurityException e1) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        this.gc.weighty = 1.0;
        this.add((Component)new Box.Filler(new Dimension(0, 0), new Dimension(10000, 10000), new Dimension(10000, 10000)), this.gc);
    }
}

