/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui.menu.midi;

import com.frinika.gui.OptionsDialog;
import com.frinika.gui.OptionsEditor;
import com.frinika.project.ProjectContainer;
import com.frinika.project.gui.ProjectFrame;
import com.frinika.sequencer.gui.ControllerSelector;
import com.frinika.sequencer.gui.TimeFormat;
import com.frinika.sequencer.gui.TimeSelector;
import com.frinika.sequencer.gui.menu.midi.MidiInsertControllersAction;
import com.frinika.sequencer.model.MidiLane;
import com.frinika.sequencer.model.MultiEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MidiInsertControllersActionEditor
extends JPanel
implements OptionsEditor {
    private MidiInsertControllersAction action;
    private ProjectFrame frame;
    private TimeSelector startTimeSelector;
    private TimeSelector lengthTimeSelector;
    private TimeSelector resolutionTimeSelector;
    private ControllerSelector controllerSelector;
    private Map<AbstractButton, MidiInsertControllersAction.ControllerFunction> functionButtons;
    private Map<MidiInsertControllersAction.ControllerFunction, JComponent> functions;
    private JPanel controllerSelectorPanel;
    private JPanel functionOptionsPanel;
    private ButtonGroup functionsButtonGroup;
    private JPanel functionsPanel;
    private JPanel headPanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel lengthTimeSelectorPanel;
    private JPanel resolutionTimeSelectorPanel;
    private JPanel startTimeSelectorPanel;

    public MidiInsertControllersActionEditor(ProjectFrame frame, MidiInsertControllersAction action) {
        this.frame = frame;
        this.action = action;
        this.initComponents();
        ProjectContainer project = frame.getProjectContainer();
        this.startTimeSelector = new TimeSelector(project, TimeFormat.BAR_BEAT_TICK);
        this.startTimeSelectorPanel.add(this.startTimeSelector);
        this.lengthTimeSelector = new TimeSelector(project, TimeFormat.BEAT_TICK);
        this.lengthTimeSelectorPanel.add(this.lengthTimeSelector);
        this.resolutionTimeSelector = new TimeSelector(project, TimeFormat.BEAT_TICK);
        this.resolutionTimeSelectorPanel.add(this.resolutionTimeSelector);
        this.controllerSelector = new ControllerSelector();
        this.controllerSelector.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((MidiInsertControllersActionEditor)MidiInsertControllersActionEditor.this).action.controller = MidiInsertControllersActionEditor.this.controllerSelector.getControllerType();
            }
        });
        this.controllerSelectorPanel.add(this.controllerSelector);
        Collection<MidiInsertControllersAction.ControllerFunction> ff = action.getAvailableControllerFunctions();
        this.functions = new HashMap<MidiInsertControllersAction.ControllerFunction, JComponent>();
        this.functionButtons = new HashMap<AbstractButton, MidiInsertControllersAction.ControllerFunction>();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets.left = 3;
        gbc.insets.right = 3;
        for (MidiInsertControllersAction.ControllerFunction function : ff) {
            String name = function.getName();
            Icon icon = function.getIcon(50, 30);
            JRadioButton rb = new JRadioButton(name);
            this.functionsButtonGroup.add(rb);
            this.functionButtons.put(rb, function);
            rb.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    JRadioButton rb = (JRadioButton)e.getSource();
                    if (rb.isSelected()) {
                        MidiInsertControllersAction.ControllerFunction f = (MidiInsertControllersAction.ControllerFunction)MidiInsertControllersActionEditor.this.functionButtons.get(rb);
                        JComponent gui = (JComponent)MidiInsertControllersActionEditor.this.functions.get(f);
                        if (gui == null) {
                            gui = f.createGUI();
                            if (gui == null) {
                                gui = new JPanel(new GridBagLayout());
                                gui.add((Component)new JLabel("(this function has no options)"), new GridBagConstraints());
                            }
                            MidiInsertControllersActionEditor.this.functions.put(f, gui);
                        }
                        MidiInsertControllersActionEditor.this.functionOptionsPanel.removeAll();
                        MidiInsertControllersActionEditor.this.functionOptionsPanel.add(gui);
                        Container parent = MidiInsertControllersActionEditor.this.getParent();
                        if (parent != null) {
                            MidiInsertControllersActionEditor.this.functionOptionsPanel.validate();
                            ((OptionsDialog)parent.getParent().getParent().getParent().getParent().getParent()).validate();
                            MidiInsertControllersActionEditor.this.functionOptionsPanel.repaint();
                        }
                    }
                }
            });
            this.functionsPanel.add((Component)rb, gbc);
            JLabel label = icon != null ? new JLabel(icon) : new JLabel(name);
            this.functionsPanel.add((Component)label, gbc);
            this.functionsPanel.add((Component)new JPanel(), gbc);
        }
        this.functionsButtonGroup.getElements().nextElement().setSelected(true);
    }

    public void refresh() {
        long start = this.frame.getProjectContainer().getSequencer().getTickPosition();
        this.startTimeSelector.setTicks(start);
        this.lengthTimeSelector.setTicks(this.action.length);
        this.resolutionTimeSelector.setTicks(this.action.resolution);
        MidiInsertControllersAction.ControllerFunction f = this.action.function;
        for (AbstractButton radiobutton : this.functionButtons.keySet()) {
            MidiInsertControllersAction.ControllerFunction ff = this.functionButtons.get(radiobutton);
            if (ff != f) continue;
            radiobutton.setSelected(true);
        }
        MultiEvent first = (MultiEvent)this.action.events.iterator().next();
        this.controllerSelector.setControllerList(((MidiLane)first.getMidiPart().getLane()).getControllerList());
        this.controllerSelector.setControllerType(this.action.controller);
        this.controllerSelector.addPseudoController("(Note)", -1);
    }

    public void update() {
        this.action.start = this.startTimeSelector.getTicks();
        this.action.length = this.lengthTimeSelector.getTicks();
        this.action.resolution = this.resolutionTimeSelector.getTicks();
        this.action.controller = this.controllerSelector.getControllerType();
        for (AbstractButton radiobutton : this.functionButtons.keySet()) {
            if (!radiobutton.isSelected()) continue;
            this.action.function = this.functionButtons.get(radiobutton);
        }
    }

    private void initComponents() {
        this.functionsButtonGroup = new ButtonGroup();
        this.headPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.startTimeSelectorPanel = new JPanel();
        this.jLabel2 = new JLabel();
        this.lengthTimeSelectorPanel = new JPanel();
        this.jLabel4 = new JLabel();
        this.controllerSelectorPanel = new JPanel();
        this.jLabel3 = new JLabel();
        this.resolutionTimeSelectorPanel = new JPanel();
        this.functionsPanel = new JPanel();
        this.functionOptionsPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.headPanel.setLayout(new GridBagLayout());
        this.jLabel1.setText("Insert at");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 3, 5, 3);
        this.headPanel.add((Component)this.jLabel1, gridBagConstraints);
        this.startTimeSelectorPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 3, 5, 3);
        this.headPanel.add((Component)this.startTimeSelectorPanel, gridBagConstraints);
        this.jLabel2.setText("Length");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 3, 5, 3);
        this.headPanel.add((Component)this.jLabel2, gridBagConstraints);
        this.lengthTimeSelectorPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 3, 5, 3);
        this.headPanel.add((Component)this.lengthTimeSelectorPanel, gridBagConstraints);
        this.jLabel4.setText("Controller");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 3, 5, 3);
        this.headPanel.add((Component)this.jLabel4, gridBagConstraints);
        this.controllerSelectorPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 3, 5, 3);
        this.headPanel.add((Component)this.controllerSelectorPanel, gridBagConstraints);
        this.jLabel3.setText("at each");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 3, 5, 3);
        this.headPanel.add((Component)this.jLabel3, gridBagConstraints);
        this.resolutionTimeSelectorPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 3, 5, 3);
        this.headPanel.add((Component)this.resolutionTimeSelectorPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        this.add((Component)this.headPanel, gridBagConstraints);
        this.functionsPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 3, 8, 3);
        this.add((Component)this.functionsPanel, gridBagConstraints);
        this.functionOptionsPanel.setLayout(new GridBagLayout());
        this.functionOptionsPanel.setBorder(BorderFactory.createEtchedBorder());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.functionOptionsPanel, gridBagConstraints);
    }
}

