/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui.menu.midi;

import com.frinika.project.gui.ProjectFrame;
import com.frinika.sequencer.gui.menu.midi.AbstractMidiAction;
import com.frinika.sequencer.gui.menu.midi.MidiDurationActionEditor;
import com.frinika.sequencer.model.MidiPart;
import com.frinika.sequencer.model.MultiEvent;
import com.frinika.sequencer.model.NoteEvent;
import java.util.Collection;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MidiDurationAction
extends AbstractMidiAction {
    public static final int MODE_SET = 1;
    public static final int MODE_CHANGE = 2;
    public static final int MODE_LEGATO = 3;
    int mode = 1;
    long setTicks = 32L;
    long changeTicks = 16L;
    int legatoGap = 1;

    public MidiDurationAction(ProjectFrame frame) {
        super(frame, "sequencer.midi.duration");
    }

    @Override
    protected JComponent createGUI() {
        return new MidiDurationActionEditor(this, this.frame);
    }

    @Override
    public void modifyNoteEvent(NoteEvent note) {
        switch (this.mode) {
            case 1: {
                note.setDuration(this.setTicks);
                break;
            }
            case 2: {
                note.setDuration(note.getDuration() + this.changeTicks);
                break;
            }
            case 3: {
                note.setDuration(MidiDurationAction.legatoDuration(note) - (long)this.legatoGap);
            }
        }
    }

    private static long legatoDuration(NoteEvent note) {
        MidiPart part = note.getMidiPart();
        long next = MidiDurationAction.findFollowingNote(part.getMultiEvents(), note.getEndTick());
        if (next == -1L) {
            return note.getDuration();
        }
        long d = next - note.getStartTick();
        return d;
    }

    private static long findFollowingNote(Collection<MultiEvent> events, long tick) {
        long next = Long.MAX_VALUE;
        for (MultiEvent event : events) {
            long start;
            if (!(event instanceof NoteEvent) || (start = event.getStartTick()) <= tick || start >= next) continue;
            next = start;
        }
        if (next != Long.MAX_VALUE) {
            return next;
        }
        return -1L;
    }
}

