/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui.menu;

import com.frinika.localization.CurrentLocale;
import com.frinika.project.gui.ProjectFrame;
import com.frinika.sequencer.model.MidiPart;
import com.frinika.sequencer.model.Part;
import com.frinika.sequencer.model.tools.Tools;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.AbstractAction;

public class SplitSelectedPartsAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private ProjectFrame project;

    public SplitSelectedPartsAction(ProjectFrame project) {
        super(CurrentLocale.getMessage("sequencer.project.split_parts"));
        this.project = project;
    }

    public void actionPerformed(ActionEvent arg0) {
        Vector<MidiPart> parts = new Vector<MidiPart>();
        for (Part part : this.project.getProjectContainer().getPartSelection().getSelected()) {
            if (!(part instanceof MidiPart)) continue;
            parts.add((MidiPart)part);
        }
        this.project.getProjectContainer().getEditHistoryContainer().mark(CurrentLocale.getMessage("sequencer.project.split_lane"));
        long ticksPerBeat = this.project.getProjectContainer().getSequence().getResolution();
        Vector<MidiPart> newParts = Tools.splitParts(parts, ticksPerBeat);
        this.project.getProjectContainer().getPartSelection().setSelected(newParts);
        this.project.getProjectContainer().getEditHistoryContainer().notifyEditHistoryListeners();
        this.project.getProjectContainer().getPartSelection().notifyListeners();
    }
}

