/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui.menu;

import com.frinika.localization.CurrentLocale;
import com.frinika.project.gui.ProjectFrame;
import com.frinika.sequencer.model.Lane;
import com.frinika.sequencer.model.MidiLane;
import com.frinika.sequencer.model.MidiPart;
import com.frinika.sequencer.model.MultiEvent;
import com.frinika.sequencer.model.Part;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;

public class SplitLaneAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private ProjectFrame project;

    public SplitLaneAction(ProjectFrame project) {
        super(CurrentLocale.getMessage("sequencer.project.split_lane"));
        this.project = project;
    }

    public void actionPerformed(ActionEvent arg0) {
        Lane lane = (Lane)this.project.getProjectContainer().getLaneSelection().getFocus();
        if (lane == null) {
            this.project.infoMessage("Please select a Lane before Spliting!");
            return;
        }
        List<Part> parts = lane.getParts();
        if (parts.isEmpty()) {
            this.project.infoMessage("Lane is empty!");
            return;
        }
        if (parts.size() != 1) {
            this.project.infoMessage("Lane must only contain 1 part!");
            return;
        }
        Part part = parts.get(0);
        if (!(part instanceof MidiPart)) {
            this.project.infoMessage("Please select  MidiLane!");
            return;
        }
        this.project.getProjectContainer().getEditHistoryContainer().mark(CurrentLocale.getMessage("sequencer.project.split_lane"));
        MidiPart mPart = (MidiPart)part;
        MidiPart newPart = new MidiPart((MidiLane)lane);
        long ticksPerBeat = this.project.getProjectContainer().getSequence().getResolution();
        long gap = ticksPerBeat / 2L;
        long lastTick = Long.MAX_VALUE;
        long tStart = 0L;
        for (MultiEvent ev : mPart.getMultiEvents()) {
            long t1 = ev.getStartTick();
            if (t1 - lastTick > gap) {
                tStart = t1;
                newPart = new MidiPart((MidiLane)lane);
            }
            lastTick = ev.getEndTick();
            newPart.add(ev);
        }
        lane.remove(part);
        this.project.getProjectContainer().getEditHistoryContainer().notifyEditHistoryListeners();
    }
}

