/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui.menu;

import com.frinika.localization.CurrentLocale;
import com.frinika.project.gui.ProjectFrame;
import com.frinika.project.scripting.FrinikaScript;
import com.frinika.project.scripting.FrinikaScriptingEngine;
import com.frinika.project.scripting.gui.ScriptingDialog;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenu;

public class ScriptingAction
extends AbstractAction {
    public static final String actionId = "sequencer.project.scripting";
    private ProjectFrame frame;
    private FrinikaScript script;
    private ScriptingDialog scriptingDialog;

    public ScriptingAction(ProjectFrame frame) {
        super(CurrentLocale.getMessage(actionId));
        this.frame = frame;
        this.script = null;
    }

    public ScriptingAction(ProjectFrame frame, FrinikaScript script) {
        super(script.getName());
        this.frame = frame;
        this.script = script;
        this.scriptingDialog = null;
    }

    public void initDialog(JMenu scriptingSubmenu) {
        this.scriptingDialog = new ScriptingDialog(this.frame, scriptingSubmenu);
    }

    public void actionPerformed(ActionEvent e) {
        if (this.script == null) {
            this.scriptingDialog.show();
        } else {
            this.frame.getProjectContainer().getScriptingEngine();
            FrinikaScriptingEngine.executeScript(this.script, this.frame, null);
        }
    }
}

