/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui.menu;

import com.frinika.localization.CurrentLocale;
import com.frinika.project.gui.ProjectFrame;
import com.frinika.tracker.MidiFileFilter;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;

public class ImportMidiToLaneAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private ProjectFrame project;

    public ImportMidiToLaneAction(ProjectFrame project) {
        super(CurrentLocale.getMessage("sequencer.project.import_midi_to_lanes"));
        this.project = project;
    }

    public void actionPerformed(ActionEvent arg0) {
        File midiFile = null;
        try {
            JFileChooser chooser = new JFileChooser();
            chooser.setDialogTitle(CurrentLocale.getMessage("project.menu.file.import_midi"));
            chooser.setFileFilter(new MidiFileFilter());
            if (midiFile != null) {
                chooser.setSelectedFile(midiFile);
            }
            if (chooser.showOpenDialog(this.project) == 0) {
                File newMidiFile = chooser.getSelectedFile();
                MidiDevice mididdevice = this.project.selectMidiDevice();
                this.project.getProjectContainer().createMidiLanesFromSequence(MidiSystem.getSequence(newMidiFile), mididdevice);
                midiFile = newMidiFile;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

