/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui;

import com.frinika.project.ProjectContainer;
import com.frinika.sequencer.gui.TickSpinner;
import com.frinika.sequencer.gui.TickSpinnerModel;
import com.frinika.sequencer.gui.TimeFormat;
import com.frinika.sequencer.model.util.TimeUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TimeSelector
extends JPanel {
    public static final String[] NOTE_LENGTH_NAMES = new String[]{"2/1", "1/1 \u00b7", "1/1", "1/2 \u00b7", "1/2", "1/4 \u00b7", "1/4", "1/8 \u00b7", "1/8", "1/16", "1/32", "1/64", "1/2 trio", "1/4 trio", "1/8 trio", "1/16 trio"};
    public static final double[] NOTE_LENGTH_FACTORS = new double[]{2.0, 1.5, 1.0, 0.75, 0.5, 0.375, 0.25, 0.1875, 0.125, 0.0625, 0.03125, 0.015625, 0.3333333333333333, 0.16666666666666666, 0.08333333333333333, 0.041666666666666664};
    private TimeFormat format;
    private JLabel label;
    private TickSpinner spinner;
    private JComboBox comboBox;
    private JList listBox;
    private boolean multiLine;
    private TimeUtils timeUtil;
    private ProjectContainer project;

    public TimeSelector(String label, long defaultTicks, boolean allowNegative, ProjectContainer project, TimeFormat format, boolean multiLine) {
        this.project = project;
        this.format = format;
        this.multiLine = multiLine;
        this.timeUtil = project.getTimeUtils();
        GridBagConstraints gc = null;
        if (label != null) {
            this.setLayout(new GridBagLayout());
            gc = new GridBagConstraints();
            gc.insets.left = 2;
            gc.insets.right = 5;
            this.label = new JLabel(label);
            this.add((Component)this.label, gc);
            gc.insets.left = 0;
            gc.fill = 2;
            gc.weightx = 1.0;
        } else {
            this.setLayout(new BorderLayout(0, 0));
        }
        if (format == TimeFormat.NOTE_LENGTH) {
            if (multiLine) {
                this.listBox = new JList<String>(NOTE_LENGTH_NAMES);
                this.listBox.setSelectionMode(0);
                this.add(new JScrollPane(this.listBox));
            } else {
                this.comboBox = new JComboBox<String>(NOTE_LENGTH_NAMES);
                this.add(this.comboBox);
            }
            if (defaultTicks == 0L) {
                defaultTicks = 64L;
            }
            this.setTicks(defaultTicks);
        } else {
            this.spinner = new TickSpinner(format, defaultTicks, allowNegative, this.timeUtil);
            if (label != null) {
                this.add((Component)this.spinner, gc);
            } else {
                this.add(this.spinner);
            }
        }
    }

    public TimeSelector(String label, long defaultTicks, ProjectContainer project, TimeFormat format, boolean multiLine) {
        this(label, defaultTicks, false, project, format, multiLine);
    }

    public TimeSelector(String label, long defaultTicks, ProjectContainer project, TimeFormat format) {
        this(label, defaultTicks, project, format, false);
    }

    public TimeSelector(String label, long defaultTicks, boolean allowNegative, ProjectContainer project, TimeFormat format) {
        this(label, defaultTicks, allowNegative, project, format, false);
    }

    public TimeSelector(String label, String defaultStr, ProjectContainer project, TimeFormat format, boolean multiLine) {
        this(null, 0L, project, format, multiLine);
        this.setString(defaultStr);
    }

    public TimeSelector(String label, String defaultStr, ProjectContainer project, TimeFormat format) {
        this(null, 0L, project, format, false);
    }

    public TimeSelector(String defaultStr, ProjectContainer project, TimeFormat format, boolean multiLine) {
        this(null, defaultStr, project, format, multiLine);
    }

    public TimeSelector(String defaultStr, ProjectContainer project, TimeFormat format) {
        this(null, defaultStr, project, format, false);
    }

    public TimeSelector(long defaultTicks, ProjectContainer project, TimeFormat format, boolean multiLine) {
        this(null, defaultTicks, project, format, multiLine);
    }

    public TimeSelector(ProjectContainer project, TimeFormat format, boolean multiLine) {
        this(0L, project, format, multiLine);
    }

    public TimeSelector(long defaultTicks, ProjectContainer project, TimeFormat format) {
        this(null, defaultTicks, project, format, false);
    }

    public TimeSelector(long defaultTicks, boolean allowNegative, ProjectContainer project, TimeFormat format) {
        this(null, defaultTicks, allowNegative, project, format, false);
    }

    public TimeSelector(ProjectContainer project, TimeFormat format) {
        this(0L, project, format, false);
    }

    public TimeSelector(ProjectContainer project) {
        this(project, TimeFormat.BAR_BEAT_TICK);
    }

    public void addChangeListener(final ChangeListener l) {
        if (this.format == TimeFormat.NOTE_LENGTH) {
            if (this.multiLine) {
                this.listBox.addListSelectionListener(new ListSelectionListener(){

                    public void valueChanged(ListSelectionEvent e) {
                        ChangeEvent ce = new ChangeEvent(TimeSelector.this.listBox);
                        l.stateChanged(ce);
                    }
                });
            } else {
                this.comboBox.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        ChangeEvent ce = new ChangeEvent(TimeSelector.this.comboBox);
                        l.stateChanged(ce);
                    }
                });
            }
        } else {
            this.spinner.addChangeListener(l);
        }
    }

    public synchronized void setTicks(long ticks) {
        if (this.format == TimeFormat.NOTE_LENGTH) {
            int i = TimeSelector.findClosest(ticks, NOTE_LENGTH_FACTORS, this.project.getSequence().getResolution());
            if (this.multiLine) {
                this.listBox.setSelectedIndex(i);
                this.listBox.ensureIndexIsVisible(i);
            } else {
                this.comboBox.setSelectedIndex(i);
            }
        } else {
            this.spinner.setValue(ticks);
        }
    }

    public long getTicks() {
        if (this.format == TimeFormat.NOTE_LENGTH) {
            int i = this.multiLine ? this.listBox.getSelectedIndex() : this.comboBox.getSelectedIndex();
            double f = NOTE_LENGTH_FACTORS[i];
            long ticks = Math.round(f * (double)this.project.getSequence().getResolution() * 4.0);
            return ticks;
        }
        String s = this.getString();
        long ticks = this.parseString(s);
        return ticks;
    }

    public synchronized void setString(String s) {
        long ticks = this.parseString(s);
        this.setTicks(ticks);
    }

    public String getString() {
        if (this.format == TimeFormat.NOTE_LENGTH) {
            return this.comboBox.getSelectedItem().toString();
        }
        return ((TickSpinnerModel)this.spinner.getModel()).ticksToString((Long)this.spinner.getValue());
    }

    public long parseString(String s) {
        return TimeSelector.parseStringImpl(s, this.timeUtil, this.format, this.project);
    }

    public String formatString(long ticks) {
        return TimeSelector.formatStringImpl(ticks, this.timeUtil, this.format);
    }

    private static long parseStringImpl(String s, TimeUtils timeUtil, TimeFormat format, ProjectContainer project) {
        int sgn = 1;
        if ((s = s.trim()).length() == 0) {
            return 0L;
        }
        char sgnch = s.charAt(0);
        if (sgnch == '-') {
            sgn = -1;
            s = s.substring(1);
        } else if (sgnch == '+') {
            s = s.substring(1);
        }
        switch (format) {
            case BAR_BEAT_TICK: {
                return (long)sgn * timeUtil.barBeatTickToTick(s);
            }
            case BAR_BEAT: {
                return (long)sgn * timeUtil.barBeatTickToTick(s + ":000");
            }
            case BEAT_TICK: {
                return (long)sgn * timeUtil.beatTickToTick(s);
            }
            case BEAT: {
                try {
                    return (long)sgn * Math.round(Double.valueOf(s) * (double)project.getSequence().getResolution());
                }
                catch (NumberFormatException nfe) {
                    return 0L;
                }
            }
        }
        return 0L;
    }

    private static String formatStringImpl(long tick, TimeUtils timeUtil, TimeFormat format) {
        String sgn;
        if (tick < 0L) {
            sgn = "-";
            tick = -tick;
        } else {
            sgn = "";
        }
        switch (format) {
            case BAR_BEAT_TICK: {
                return sgn + timeUtil.tickToBarBeatTick(tick);
            }
            case BAR_BEAT: {
                return sgn + timeUtil.tickToBarBeat(tick);
            }
            case BEAT_TICK: {
                return sgn + timeUtil.tickToBeatTick(tick);
            }
            case BEAT: {
                return sgn + String.valueOf(timeUtil.tickToFloatBeat(tick));
            }
        }
        return "---";
    }

    private static int findClosest(long ticks, double[] factors, int resolution) {
        long diff = Long.MAX_VALUE;
        int result = -1;
        for (int i = 0; i < factors.length; ++i) {
            long t = Math.round(factors[i] * (double)resolution * 4.0);
            if (t == ticks) {
                return i;
            }
            long d = ticks - t;
            if (d < 0L) {
                d = -d;
            }
            if (d >= diff) continue;
            diff = d;
            result = i;
        }
        return result;
    }

    private static int findIndex(Object[] a, Object o) {
        for (int i = 0; i < a.length; ++i) {
            if (a[i] != o) continue;
            return i;
        }
        return -1;
    }
}

