/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui;

import com.frinika.sequencer.gui.TimeFormat;
import com.frinika.sequencer.model.util.TimeUtils;
import java.text.ParseException;
import javax.swing.SpinnerNumberModel;

public class TickSpinnerModel
extends SpinnerNumberModel {
    protected TimeFormat format;
    protected TimeUtils timeUtils;
    private boolean suppressFireStateChange = false;

    public TickSpinnerModel(TimeUtils timeUtils) {
        this(TimeFormat.BAR_BEAT_TICK, 0L, timeUtils);
    }

    public TickSpinnerModel(TimeFormat format, TimeUtils timeUtils) {
        this(format, 0L, timeUtils);
    }

    public TickSpinnerModel(long value, TimeUtils timeUtils) {
        this(timeUtils);
        this.setValue(value);
    }

    public TickSpinnerModel(TimeFormat format, long value, TimeUtils timeUtils) {
        this(format, value, false, timeUtils);
    }

    public TickSpinnerModel(TimeFormat format, long value, boolean allowNegative, TimeUtils timeUtils) {
        super((Number)value, allowNegative ? null : Long.valueOf(0L), null, (Number)1L);
        this.format = format;
        this.timeUtils = timeUtils;
    }

    public TimeFormat getFormat() {
        return this.format;
    }

    public long stringToTicks(String s) throws ParseException {
        try {
            switch (this.format) {
                case BEAT: {
                    return Math.round(Float.parseFloat(s) * (float)this.timeUtils.ticksPerBeat());
                }
                case NOTE_LENGTH: {
                    return -1L;
                }
            }
            if (s.indexOf(58) == -1) {
                s = s + ":000";
            }
            if (s.indexOf(46) == -1) {
                return this.timeUtils.beatTickToTick(s);
            }
            return this.timeUtils.barBeatTickToTick(s);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ParseException(e.getMessage(), 0);
        }
    }

    public String ticksToString(long tick) {
        switch (this.format) {
            case BAR_BEAT_TICK: {
                return this.timeUtils.tickToBarBeatTick(tick);
            }
            case BEAT_TICK: {
                return this.timeUtils.tickToBeatTick(tick);
            }
            case BAR_BEAT: {
                return this.timeUtils.tickToBarBeat(tick);
            }
            case BEAT: {
                return String.valueOf((float)tick / (float)this.timeUtils.ticksPerBeat());
            }
            case NOTE_LENGTH: {
                return null;
            }
        }
        assert (false);
        return null;
    }

    public void updateStepSize(String currentValue, int caretPos) {
        int s = this.getStepSize(currentValue, caretPos);
        this.setStepSizeNoStateChange(s);
    }

    private synchronized void setStepSizeNoStateChange(Number stepSize) {
        this.suppressFireStateChange = true;
        super.setStepSize(stepSize);
        this.suppressFireStateChange = false;
    }

    protected void fireStateChanged() {
        if (!this.suppressFireStateChange) {
            super.fireStateChanged();
        }
    }

    public int getStepSize(String currentValue, int caretPos) {
        if (this.format == TimeFormat.BEAT) {
            return (int)this.timeUtils.ticksPerBeat();
        }
        int colonPos = currentValue.lastIndexOf(58);
        if (caretPos > colonPos) {
            return 1;
        }
        int dotPos = currentValue.lastIndexOf(46);
        if (caretPos > dotPos) {
            return (int)this.timeUtils.ticksPerBeat();
        }
        return (int)(this.timeUtils.ticksPerBeat() * (long)this.timeUtils.beatsPerBar((Long)this.getValue()));
    }
}

