/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui;

import com.frinika.sequencer.gui.JSpinnerDraggable;
import com.frinika.sequencer.gui.TickSpinnerModel;
import com.frinika.sequencer.gui.TimeFormat;
import com.frinika.sequencer.model.util.TimeUtils;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class TickSpinner
extends JSpinnerDraggable
implements CaretListener {
    public TickSpinner() {
        this.init();
    }

    public TickSpinner(TickSpinnerModel model) {
        super(model);
        this.init();
    }

    public TickSpinner(TimeFormat format, long value, TimeUtils timeUtils) {
        this(format, value, false, timeUtils);
    }

    public TickSpinner(TimeFormat format, long value, boolean allowNegative, TimeUtils timeUtils) {
        this(new TickSpinnerModel(format, value, allowNegative, timeUtils));
    }

    public TickSpinner(TimeFormat format, TimeUtils timeUtils) {
        this(format, 0L, timeUtils);
    }

    public Object getNextValue() {
        return super.getNextValue();
    }

    private void init() {
        JFormattedTextField ftf = ((JSpinner.DefaultEditor)this.getEditor()).getTextField();
        ftf.setColumns(((TickSpinnerModel)this.getModel()).format.textFieldSize);
        ftf.setFormatterFactory(new JFormattedTextField.AbstractFormatterFactory(){

            public JFormattedTextField.AbstractFormatter getFormatter(JFormattedTextField tf) {
                return new JFormattedTextField.AbstractFormatter(){

                    public Object stringToValue(String text) throws ParseException {
                        return ((TickSpinnerModel)TickSpinner.this.getModel()).stringToTicks(text);
                    }

                    public String valueToString(Object value) throws ParseException {
                        return ((TickSpinnerModel)TickSpinner.this.getModel()).ticksToString((Long)value);
                    }
                };
            }
        });
        ftf.addCaretListener(this);
    }

    public void commitEdit() throws ParseException {
        final JFormattedTextField textField = ((JSpinner.DefaultEditor)this.getEditor()).getTextField();
        final int pos = textField.getCaretPosition();
        super.commitEdit();
        new Thread(){

            public void run() {
                try {
                    textField.setCaretPosition(pos);
                }
                catch (IllegalArgumentException ie) {
                    ie.printStackTrace();
                }
            }
        }.start();
    }

    public void caretUpdate(CaretEvent e) {
        TickSpinnerModel model = (TickSpinnerModel)this.getModel();
        JFormattedTextField textField = ((JSpinner.DefaultEditor)this.getEditor()).getTextField();
        int pos = textField.getCaretPosition();
        model.updateStepSize(textField.getText(), pos);
    }
}

