/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui;

import com.frinika.project.gui.ProjectFrame;
import com.frinika.sequencer.gui.Snapable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.sound.midi.Sequence;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NoteLengthPopup
extends JPopupMenu
implements ActionListener {
    private static final long serialVersionUID = 1L;
    String[] notes = new String[]{"bar", "1", "1/2", "1/3", "1/4", "1/6", "1/8"};
    static Icon[] icons = new Icon[]{ProjectFrame.getIconResource("note_1.png"), ProjectFrame.getIconResource("note_4.png"), ProjectFrame.getIconResource("note_8.png"), ProjectFrame.getIconResource("note_12.png"), ProjectFrame.getIconResource("note_16.png"), ProjectFrame.getIconResource("note_24.png"), ProjectFrame.getIconResource("note_32.png")};
    int[] numA = new int[]{-1, 1, 1, 1, 1, 1, 1};
    int[] denA = new int[]{1, 1, 2, 3, 4, 6, 8};
    public int den = 1;
    public int num = 1;
    Vector<Snapable> clients;
    Sequence sequence;
    JButton button;

    public static void updateButton(JButton button, double snap) {
        int index = -1;
        if (Math.abs(snap - 4.0) < 0.01 || snap < 0.0) {
            index = 0;
        }
        if (Math.abs(snap - 1.0) < 0.01) {
            index = 1;
        }
        if (Math.abs(snap - 0.5) < 0.01) {
            index = 2;
        }
        if (Math.abs(snap - 0.3333333333333333) < 0.01) {
            index = 3;
        }
        if (Math.abs(snap - 0.25) < 0.01) {
            index = 4;
        }
        if (Math.abs(snap - 0.16666666666666666) < 0.01) {
            index = 5;
        }
        if (Math.abs(snap - 0.125) < 0.01) {
            index = 6;
        }
        if (index != -1) {
            button.setIcon(icons[index]);
        }
    }

    public static void updateButton(JButton button, Vector<Snapable> clients, Sequence sequence) {
        for (Snapable client : clients) {
            NoteLengthPopup.updateButton(button, client.getSnapQuantization() / (double)sequence.getResolution());
        }
    }

    NoteLengthPopup(JButton button, Vector<Snapable> clients, Sequence sequence) {
        this.button = button;
        this.sequence = sequence;
        this.clients = clients;
        NoteLengthPopup.updateButton(button, clients, sequence);
        int i = 0;
        for (String str : this.notes) {
            JMenuItem item = new JMenuItem(str, icons[i++]);
            item.addActionListener(this);
            this.add(item);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        for (int i = 0; i < this.notes.length; ++i) {
            if (!e.getActionCommand().equals(this.notes[i])) continue;
            double quant = this.sequence.getResolution();
            quant = quant * (double)this.numA[i] / (double)this.denA[i];
            NoteLengthPopup.updateButton(this.button, quant / (double)this.sequence.getResolution());
            for (Snapable client : this.clients) {
                client.setSnapQuantization(quant);
            }
            return;
        }
    }
}

