/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui;

import com.frinika.sequencer.gui.AudioDeviceHandle;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.TargetDataLine;
import uk.org.toot.audio.server.AudioServer;

public class MixerAudioDeviceHandle
implements AudioDeviceHandle {
    private Mixer mixer;
    private AudioFormat af;
    private DataLine.Info info;
    private TargetDataLine line;
    private AudioServer server;
    private byte[] inBuffer;

    public MixerAudioDeviceHandle(Mixer mixer, AudioFormat af, DataLine.Info info, AudioServer server) {
        this.mixer = mixer;
        this.af = af;
        this.info = info;
        this.line = null;
        this.server = server;
    }

    public String toString() {
        if (this.af.getChannels() == 1) {
            return this.mixer.getMixerInfo().getName() + " (MONO)";
        }
        if (this.af.getChannels() == 2) {
            return this.mixer.getMixerInfo().getName() + " (STEREO)";
        }
        return this.mixer.getMixerInfo().getName() + "channels=" + this.af.getChannels();
    }

    public TargetDataLine getLine() {
        try {
            System.out.println(this + " **** " + this.af);
            DataLine.Info infoIn = new DataLine.Info(TargetDataLine.class, this.af);
            this.line = (TargetDataLine)this.mixer.getLine(infoIn);
        }
        catch (LineUnavailableException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void fillBuffers(int nFrame) {
        try {
            int nByte = this.af.getChannels() * nFrame * 2;
            if (this.inBuffer == null || this.inBuffer.length != nByte) {
                this.inBuffer = new byte[nByte];
            }
            if (this.line.available() >= nByte && nByte > 0) {
                int cnt = 0;
                do {
                    int nread;
                    if ((nread = this.line.read(this.inBuffer, 0, nByte)) == 0) {
                        System.out.println("active :" + this.line.isActive() + " available:" + this.line.available() + " nByte: " + nByte + " inBuffersize: " + this.inBuffer.length);
                    }
                    ++cnt;
                    for (int n = 0; n < nByte / 2; ++n) {
                        short sample = (short)((0xFF & this.inBuffer[2 * n + 1]) + (0xFF & this.inBuffer[2 * n]) * 256);
                        float val = (float)sample / 32768.0f;
                    }
                } while (this.line.available() > 2 * nByte);
                if (cnt != 1) {
                    System.out.println(" COUNT WAS " + cnt);
                }
            } else {
                System.err.println(String.format(" GLITCH avail=%d actual=%d ", this.line.available(), nByte));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public TargetDataLine getOpenLine() {
        if (this.isOpen()) {
            return this.line;
        }
        try {
            if (this.line == null) {
                this.line = (TargetDataLine)this.mixer.getLine(this.info);
            }
            this.line.open(this.af);
            return this.line;
        }
        catch (LineUnavailableException e) {
            e.printStackTrace();
            return null;
        }
    }

    public int getChannels() {
        return this.af.getChannels();
    }

    public AudioFormat getFormat() {
        return this.af;
    }

    public boolean isOpen() {
        if (this.line == null) {
            return false;
        }
        return this.line.isOpen();
    }

    public void open() {
        System.out.println(" Opening MixrerAudioDevice line");
        if (this.isOpen()) {
            return;
        }
        try {
            if (this.line == null) {
                this.line = (TargetDataLine)this.mixer.getLine(this.info);
            }
            this.line.open(this.af);
            System.out.println("  . . ..  Open");
            this.line.start();
            System.out.println("  . . ..  Start  " + this.isOpen());
        }
        catch (LineUnavailableException e) {
            e.printStackTrace();
        }
    }

    public void close() {
        if (!this.isOpen()) {
            return;
        }
        this.line.close();
    }

    public byte[] getBuffer() {
        return this.inBuffer;
    }
}

