/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui;

import com.frinika.project.ProjectContainer;
import com.frinika.sequencer.gui.JSpinnerDraggable;
import com.frinika.sequencer.gui.MyAbstractTableModel;
import com.frinika.sequencer.gui.NoteSelector;
import com.frinika.sequencer.gui.TimeFormat;
import com.frinika.sequencer.gui.TimeSelector;
import com.frinika.sequencer.gui.menu.midi.MidiStepRecordAction;
import com.frinika.sequencer.model.util.TimeUtils;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;

public class LabelFieldEditor
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JComponent editor;
    private JLabel label;
    AbstractTableModel model;
    private int column;
    private TimeUtils timeUtil;
    private String textBackup = null;
    boolean isUpdateing = false;

    public LabelFieldEditor(MyAbstractTableModel model, int column, ProjectContainer project) {
        this.timeUtil = new TimeUtils(project);
        this.setLayout(new FlowLayout(1, 2, 0));
        this.model = model;
        this.column = column;
        this.label = new JLabel(model.getColumnName(column));
        this.add(this.label);
        this.editor = this.createEditor(model, column, project);
        this.update();
        this.add(this.editor);
    }

    protected JComponent createEditor(final MyAbstractTableModel model, int columnIndex, ProjectContainer project) {
        switch (this.column) {
            case 0: 
            case 3: {
                final TimeSelector ts = new TimeSelector(project, this.column == 0 ? TimeFormat.BAR_BEAT_TICK : TimeFormat.BEAT_TICK);
                ts.addChangeListener(new ChangeListener(){

                    public void stateChanged(ChangeEvent e) {
                        if (LabelFieldEditor.this.isUpdateing) {
                            return;
                        }
                        Long ticks = ts.getTicks();
                        if (ticks == null) {
                            return;
                        }
                        model.setValueAt(LabelFieldEditor.this.timeUtil.tickToBarBeatTick(ticks), 0, LabelFieldEditor.this.column);
                    }
                });
                return ts;
            }
            case 2: {
                final JSpinnerDraggable spinner = new JSpinnerDraggable(new SpinnerNumberModel(0, 0, 127, 1));
                spinner.addChangeListener(new ChangeListener(){

                    public void stateChanged(ChangeEvent e) {
                        if (LabelFieldEditor.this.isUpdateing) {
                            return;
                        }
                        model.setValueAt(spinner.getValue().toString(), 0, LabelFieldEditor.this.column);
                    }
                });
                return spinner;
            }
            case 1: {
                final NoteSelector ns = new NoteSelector();
                ns.addItem("-");
                ns.setSelectedIndex(128);
                ns.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        if (LabelFieldEditor.this.isUpdateing) {
                            return;
                        }
                        int sel = ns.getSelectedIndex();
                        if (sel <= 127) {
                            model.setValueAt(MidiStepRecordAction.formatNote(127 - sel), 0, LabelFieldEditor.this.column);
                        }
                    }
                });
                return ns;
            }
        }
        assert (false);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        try {
            this.isUpdateing = true;
            Object o = this.model.getValueAt(0, this.column);
            if (o == null || o.toString().equals("null")) {
                JComponent e = this.editor;
                if (e instanceof TimeSelector) {
                    e = (JComponent)e.getComponent(0);
                }
                if (e instanceof JSpinner) {
                    JFormattedTextField tf = ((JSpinner.DefaultEditor)((JSpinner)e).getEditor()).getTextField();
                    String t = tf.getText();
                    if (t != null && t.length() > 0) {
                        this.textBackup = t;
                    }
                    tf.setText("");
                } else if (e instanceof NoteSelector) {
                    ((NoteSelector)e).setSelectedIndex(128);
                }
                this.editor.setEnabled(false);
                this.label.setText("N.A.");
            } else {
                long value = 0L;
                switch (this.column) {
                    case 0: 
                    case 3: {
                        value = this.timeUtil.barBeatTickToTick(o.toString());
                        break;
                    }
                    case 1: {
                        value = MidiStepRecordAction.parseNote(o.toString());
                        break;
                    }
                    case 2: {
                        value = Integer.parseInt(o.toString());
                    }
                }
                if (this.editor instanceof TimeSelector) {
                    JComponent e = (JComponent)this.editor.getComponent(0);
                    this.restoreTextBackup((JSpinner)e);
                    ((JSpinner)e).setValue(value);
                } else if (this.editor instanceof JSpinner) {
                    this.restoreTextBackup((JSpinner)this.editor);
                    ((JSpinner)this.editor).setValue((int)value);
                } else if (this.editor instanceof NoteSelector) {
                    int i = 127 - (int)value;
                    if (((NoteSelector)this.editor).getSelectedIndex() != i) {
                        ((NoteSelector)this.editor).setSelectedIndex(i);
                    }
                }
                this.editor.setEnabled(true);
                this.label.setText(this.model.getColumnName(this.column));
            }
        }
        finally {
            this.isUpdateing = false;
        }
    }

    private void restoreTextBackup(JSpinner e) {
        JFormattedTextField tf;
        String s;
        if (this.textBackup != null && ((s = (tf = ((JSpinner.DefaultEditor)e.getEditor()).getTextField()).getText()) == null || s.length() == 0)) {
            tf.setText(this.textBackup);
        }
    }
}

