/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui;

import com.frinika.sequencer.gui.ItemPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;

public abstract class ItemScrollPane
extends JPanel
implements AdjustmentListener {
    private static final long serialVersionUID = 1L;
    protected ItemPanel itemPanel;
    protected JScrollBar horizScroll;
    public JScrollBar vertScroll;
    JPanel vPanel;
    JPanel buts;
    JButton plus;
    JButton minus;

    protected ItemScrollPane() {
        super(false);
        this.setLayout(new BorderLayout());
        this.horizScroll = new JScrollBar(0);
        this.add((Component)this.horizScroll, "South");
        this.horizScroll.addAdjustmentListener(this);
        this.vertScroll = new JScrollBar(1);
        this.vPanel = new JPanel();
        this.vPanel.setLayout(new BorderLayout());
        this.buts = new JPanel();
        this.buts.setLayout(new BorderLayout());
        final JButton plus = new JButton("+");
        this.buts.add((Component)plus, "North");
        JButton minus = new JButton("-");
        this.buts.add((Component)minus, "South");
        Insets m = new Insets(0, 0, 0, 0);
        plus.setMargin(m);
        minus.setMargin(m);
        ActionListener vzoom = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JButton but = (JButton)e.getSource();
                if (but == plus) {
                    ItemScrollPane.this.vertZoom(1);
                } else {
                    ItemScrollPane.this.vertZoom(-1);
                }
                ItemScrollPane.this.rebuild();
            }
        };
        plus.addActionListener(vzoom);
        minus.addActionListener(vzoom);
        this.vPanel.add((Component)this.vertScroll, "Center");
        this.vPanel.add((Component)this.buts, "North");
        this.add((Component)this.vPanel, "East");
        this.vertScroll.addAdjustmentListener(this);
    }

    protected abstract void vertZoom(int var1);

    protected abstract void rebuild();

    protected void setView(ItemPanel itemPanel) {
        assert (itemPanel != null);
        this.itemPanel = itemPanel;
    }

    protected void setToolBar(JComponent tb) {
        this.add((Component)tb, "North");
    }

    public void adjustmentValueChanged(AdjustmentEvent ev) {
        if (this.itemPanel == null) {
            return;
        }
        JScrollBar bar = (JScrollBar)ev.getSource();
        int val = ev.getValue();
        if (bar == this.horizScroll) {
            this.itemPanel.setX(val);
        }
        if (bar == this.vertScroll) {
            this.itemPanel.setY(ev.getValue());
        }
    }

    public void setX(int left) {
        this.horizScroll.setValue(left);
    }

    public void scrollBy(int dx, int dy) {
        this.itemPanel.itemViewRect.translate(dx, dy);
        if (this.itemPanel.itemViewRect.x < 0) {
            this.itemPanel.itemViewRect.x = 0;
        }
        if (this.itemPanel.itemViewRect.y < 0) {
            this.itemPanel.itemViewRect.y = 0;
        }
        if (this.horizScroll.getMaximum() < this.itemPanel.itemViewRect.x) {
            this.horizScroll.setMaximum(this.itemPanel.itemViewRect.x);
        }
        this.horizScroll.setValue(this.itemPanel.itemViewRect.x);
        this.vertScroll.setValue(this.itemPanel.itemViewRect.y);
        this.itemPanel.paintImages();
        this.itemPanel.repaint();
    }
}

