/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui;

import com.frinika.sequencer.gui.pianoroll.ControllerHandle;
import com.frinika.sequencer.model.ControllerListProvider;
import java.awt.BorderLayout;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class ControllerSelector
extends JPanel {
    int controllerType = 7;
    private JComboBox comboBox = new JComboBox();

    public ControllerSelector() {
        super(new BorderLayout());
        this.comboBox.setEditable(true);
        this.add(this.comboBox);
    }

    public int getControllerType() {
        Object o = this.comboBox.getSelectedItem();
        if (o instanceof ControllerHandle) {
            ControllerHandle ch = (ControllerHandle)o;
            this.controllerType = ch.getController();
        } else if (o instanceof String) {
            try {
                this.controllerType = Integer.parseInt((String)o);
            }
            catch (NumberFormatException nfe) {
                nfe.printStackTrace();
            }
        }
        return this.controllerType;
    }

    public void setControllerType(int controllerType) {
        this.controllerType = controllerType;
        for (int i = 0; i < this.comboBox.getItemCount(); ++i) {
            ControllerHandle ch = (ControllerHandle)this.comboBox.getItemAt(i);
            if (ch.getController() != controllerType) continue;
            this.comboBox.setSelectedIndex(i);
            return;
        }
        this.comboBox.getEditor().setItem(String.valueOf(controllerType));
    }

    public void setControllerList(ControllerListProvider clp) {
        this.comboBox.setModel(new DefaultComboBoxModel<Object>(clp.getList()));
    }

    public void addPseudoController(String name, int nr) {
        this.comboBox.addItem(new ControllerHandle(name, 0, 0, nr, nr));
    }

    public void addActionListener(ActionListener l) {
        this.comboBox.addActionListener(l);
    }

    public void removeActionListener(ActionListener l) {
        this.comboBox.removeActionListener(l);
    }
}

