/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.converter;

import com.frinika.sequencer.midi.message.TempoMessage;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.Sequence;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Track;

public class MidiSequenceConverter {
    public static Sequence splitChannelsToMultiTrack(Sequence sequence) {
        int n;
        int n2;
        System.out.println("Scanning sequence with " + sequence.getTracks().length + " tracks.");
        Track track = sequence.getTracks()[0];
        boolean[] channelsUsed = new boolean[16];
        for (n2 = 0; n2 < track.size(); ++n2) {
            MidiEvent event = track.get(n2);
            if (!(event.getMessage() instanceof ShortMessage)) continue;
            ShortMessage message = (ShortMessage)event.getMessage();
            channelsUsed[message.getChannel()] = true;
        }
        System.out.print("Channels used: ");
        for (n2 = 0; n2 < channelsUsed.length; ++n2) {
            if (!channelsUsed[n2]) continue;
            System.out.print(n2 + " ");
        }
        System.out.println();
        Integer[] channelToTrackMapping = new Integer[16];
        int tracksCreated = 0;
        for (n = 0; n < channelsUsed.length; ++n) {
            if (!channelsUsed[n]) continue;
            sequence.createTrack();
            channelToTrackMapping[n] = tracksCreated++;
        }
        System.out.println("Created " + tracksCreated + " new tracks.");
        for (n = 0; n < track.size(); ++n) {
            MidiEvent event = track.get(n);
            if (!(event.getMessage() instanceof ShortMessage)) continue;
            ShortMessage message = (ShortMessage)event.getMessage();
            sequence.getTracks()[channelToTrackMapping[message.getChannel()] + 1].add(event);
            track.remove(event);
            --n;
        }
        System.out.println("Events moved into new tracks. Initial track kept as mastertrack for tempo change etc.");
        return sequence;
    }

    public static float findFirstTempo(Sequence sequence) throws Exception {
        for (Track track : sequence.getTracks()) {
            for (int n = 0; n < track.size(); ++n) {
                MidiEvent event = track.get(n);
                if (!(event.getMessage() instanceof MetaMessage) || ((MetaMessage)event.getMessage()).getType() != 81) continue;
                float tempo = new TempoMessage((MetaMessage)event.getMessage()).getBpm();
                System.out.println("Found tempomessage " + tempo + " bpm");
                return tempo;
            }
        }
        throw new Exception("No tempo message found");
    }
}

