/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer;

import java.util.HashMap;
import java.util.HashSet;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;

public class NoteOnCache {
    private HashMap<Receiver, HashSet<Integer>> pendingNoteOffs = new HashMap();

    public final void interceptMessage(MidiMessage msg, Receiver receiver) {
        try {
            ShortMessage shm = (ShortMessage)msg;
            if (shm.getCommand() == 144) {
                if (shm.getData2() == 0) {
                    this.pendingNoteOffs.get(receiver).remove(shm.getChannel() << 8 | shm.getData1());
                } else {
                    if (!this.pendingNoteOffs.containsKey(receiver)) {
                        this.pendingNoteOffs.put(receiver, new HashSet());
                    }
                    this.pendingNoteOffs.get(receiver).add(shm.getChannel() << 8 | shm.getData1());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void releasePendingNoteOffs() {
        for (Receiver recv : this.pendingNoteOffs.keySet()) {
            for (int note : this.pendingNoteOffs.get(recv)) {
                ShortMessage shm = new ShortMessage();
                try {
                    shm.setMessage(144, note >> 8 & 0xF, note & 0xFF, 0);
                    recv.send(shm, -1L);
                }
                catch (InvalidMidiDataException e) {
                    e.printStackTrace();
                }
            }
        }
        this.pendingNoteOffs.clear();
    }
}

