/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer;

import com.frinika.midi.DrumMapper;
import com.frinika.sequencer.ChannelListProvider;
import com.frinika.sequencer.FrinikaSequencer;
import com.frinika.sequencer.gui.mixer.SynthWrapper;
import com.frinika.sequencer.model.ControllerListProvider;
import com.frinika.sequencer.model.GMControllerList;
import com.frinika.sequencer.patchname.PatchNameMap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.HashMap;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.Synthesizer;

public class MidiResource {
    static Integer[] chanList = new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};
    FrinikaSequencer sequencer;
    HashMap<String, PatchNameMap> voiceTreeMap;
    String[] patchFiles = new String[]{"SW1000", "default"};
    static ControllerListProvider defaultControllerList = new GMControllerList();

    public MidiResource(FrinikaSequencer sequencer) {
        this.sequencer = sequencer;
        this.voiceTreeMap = new HashMap();
        for (String name : this.patchFiles) {
            PatchNameMap sw = this.loadSerial(name);
            if (sw == null) continue;
            this.voiceTreeMap.put(name, sw);
        }
    }

    private PatchNameMap loadSerial(String name) {
        PatchNameMap pn = null;
        try {
            InputStream is = ClassLoader.getSystemResource("patchnames/" + name + ".pat").openStream();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            while (is.available() > 0) {
                bos.write(is.read());
            }
            ByteArrayInputStream str = new ByteArrayInputStream(bos.toByteArray());
            try {
                ObjectInputStream ois = new ObjectInputStream(str);
                pn = (PatchNameMap)ois.readObject();
                ois.close();
                str.close();
                return pn;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private PatchNameMap loadTxt(String name) {
        try {
            InputStream is = ClassLoader.getSystemResource("patchnames/" + name + ".txt").openStream();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            while (is.available() > 0) {
                bos.write(is.read());
            }
            ByteArrayInputStream str = new ByteArrayInputStream(bos.toByteArray());
            PatchNameMap sw = new PatchNameMap(str);
            return sw;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Object[] getOutChannelList(MidiDevice dev) {
        if (dev instanceof ChannelListProvider) {
            return ((ChannelListProvider)((Object)dev)).getList();
        }
        return chanList;
    }

    public PatchNameMap getVoiceList(MidiDevice dev, int channel) {
        if (!(dev instanceof SynthWrapper)) {
            return null;
        }
        assert (dev instanceof SynthWrapper);
        if (channel < 0) {
            return null;
        }
        if (((SynthWrapper)dev).getRealDevice() instanceof Synthesizer) {
            return new PatchNameMap((Synthesizer)dev, channel);
        }
        if (((SynthWrapper)dev).getRealDevice() instanceof DrumMapper) {
            return null;
        }
        String lookup = dev.getDeviceInfo().toString().split("\\s")[0];
        PatchNameMap vl = this.voiceTreeMap.get(lookup);
        if (vl == null) {
            System.out.println(" Could not find voice map for \"" + lookup + "\"");
            return this.voiceTreeMap.get("default");
        }
        return vl;
    }

    public static ControllerListProvider getDefaultControllerList() {
        return defaultControllerList;
    }

    public PatchNameMap getVoiceList(File patchMapName) {
        try {
            return new PatchNameMap(new FileInputStream(patchMapName));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

