/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.renderer;

import java.util.Arrays;
import java.util.zip.CRC32;
import javax.sound.midi.MidiEvent;

public class MidiPacket {
    public long length = 0L;
    public int channel = 0;
    public int[] activenotes = null;
    public int[] activenotes_velocity = null;
    public int[] controls = null;
    public int[] controls_values = null;
    public int program = -1;
    public int pitchbend_data1 = -1;
    public int pitchbend_data2 = -1;
    public MidiEvent[] events = null;
    private boolean checksumset = false;
    private int checksum_value = 0;

    public int checksum() {
        int i;
        if (this.checksumset) {
            return this.checksum_value;
        }
        CRC32 crc32 = new CRC32();
        crc32.update((byte)this.channel);
        crc32.update((byte)this.program);
        crc32.update((byte)this.pitchbend_data1);
        crc32.update((byte)this.pitchbend_data2);
        for (int i2 = 0; i2 < this.events.length; ++i2) {
            crc32.update(this.events[i2].getMessage().getMessage());
        }
        if (this.controls != null) {
            int[] sorted = new int[this.controls.length];
            for (i = 0; i < this.controls.length; ++i) {
                sorted[i] = (this.controls[i] << 2) + this.controls_values[i];
            }
            Arrays.sort(sorted);
            for (i = 0; i < sorted.length; ++i) {
                crc32.update((byte)(sorted[i] & 0xFF));
                crc32.update((byte)((sorted[i] & 0xFF00) >> 2));
            }
        }
        if (this.activenotes != null) {
            int[] sorted = new int[this.activenotes.length];
            for (i = 0; i < this.activenotes.length; ++i) {
                sorted[i] = (this.activenotes[i] << 2) + this.activenotes_velocity[i];
            }
            Arrays.sort(sorted);
            for (i = 0; i < sorted.length; ++i) {
                crc32.update((byte)(sorted[i] & 0xFF));
                crc32.update((byte)((sorted[i] & 0xFF00) >> 2));
            }
        }
        this.checksumset = true;
        this.checksum_value = (int)crc32.getValue();
        return this.checksum_value;
    }
}

