/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.renderer;

import com.frinika.project.ProjectContainer;
import com.frinika.renderer.FrinikaDeviceRenderer;
import com.frinika.renderer.RenderDialog;
import com.frinika.sequencer.FrinikaSequence;
import com.frinika.sequencer.FrinikaSequencer;
import com.frinika.sequencer.FrinikaTrackWrapper;
import com.frinika.sequencer.SequencerListener;
import com.frinika.sequencer.gui.mixer.SynthWrapper;
import com.frinika.sequencer.model.Lane;
import com.frinika.sequencer.model.MidiLane;
import com.frinika.sequencer.model.MidiPlayOptions;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import javax.sound.midi.MidiDevice;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class FrinikaRenderer
implements SequencerListener {
    ProjectContainer project;
    FrinikaSequencer seqr;
    ArrayList<FrinikaDeviceRenderer> deviceRenderers = new ArrayList();
    boolean started = false;
    int rendermode = 0;
    boolean suppress_realtime = true;

    public FrinikaDeviceRenderer getDeviceRenderer(MidiDevice mididevice) {
        for (FrinikaDeviceRenderer render : this.deviceRenderers) {
            if (render.getDevice() != mididevice) continue;
            return render;
        }
        FrinikaDeviceRenderer render = new FrinikaDeviceRenderer(this, mididevice);
        this.deviceRenderers.add(render);
        return render;
    }

    public FrinikaRenderer(ProjectContainer project) {
        this.project = project;
        this.seqr = project.getSequencer();
        this.seqr.addSequencerListener(this);
    }

    public MidiLane findLane(FrinikaTrackWrapper track) {
        for (Lane lane : this.project.getLanes()) {
            MidiLane midilane;
            if (!(lane instanceof MidiLane) || (midilane = (MidiLane)lane).getTrack() != track) continue;
            return midilane;
        }
        return null;
    }

    public boolean anyLaneWithPreRendering() {
        for (Lane lane : this.project.getLanes()) {
            MidiLane midilane;
            if (!(lane instanceof MidiLane) || (midilane = (MidiLane)lane).getPlayOptions() == null || !midilane.getPlayOptions().preRendered) continue;
            return true;
        }
        return false;
    }

    public void beforeStart() {
        if (this.started) {
            return;
        }
        this.started = true;
        FrinikaSequence seq = this.project.getSequence();
        for (FrinikaTrackWrapper track : seq.getFrinikaTrackWrappers()) {
            MidiPlayOptions opt = this.seqr.getPlayOptions(track);
            if (opt == null) continue;
            if (this.rendermode > 0) {
                opt.preRenderedUsed = true;
                continue;
            }
            opt.preRenderedUsed = false;
        }
        Collection<FrinikaTrackWrapper> tracks = this.seqr.getSoloFrinikaTrackWrappers().size() > 0 ? this.seqr.getSoloFrinikaTrackWrappers() : seq.getFrinikaTrackWrappers();
        HashSet<SynthWrapper> supress_candidates = new HashSet<SynthWrapper>();
        for (FrinikaTrackWrapper frinikaTrackWrapper : tracks) {
            SynthWrapper synth;
            MidiDevice dev;
            MidiPlayOptions opt;
            if (frinikaTrackWrapper.getMidiDevice() == null || (opt = this.seqr.getPlayOptions(frinikaTrackWrapper)) == null || opt.muted || !opt.preRendered || !((dev = frinikaTrackWrapper.getMidiDevice()) instanceof SynthWrapper) || !(synth = (SynthWrapper)dev).isRenderable()) continue;
            if (this.suppress_realtime) {
                supress_candidates.add(synth);
            }
            opt.preRenderedUsed = true;
            this.getDeviceRenderer(synth).addTrack(frinikaTrackWrapper);
        }
        for (FrinikaTrackWrapper frinikaTrackWrapper : tracks) {
            MidiPlayOptions opt;
            MidiDevice dev = frinikaTrackWrapper.getMidiDevice();
            if (supress_candidates.contains(dev)) {
                // empty if block
            }
            if ((opt = this.seqr.getPlayOptions(frinikaTrackWrapper)) != null && !opt.preRendered) {
                supress_candidates.remove(dev);
                continue;
            }
            MidiLane lane = this.findLane(frinikaTrackWrapper);
            if (lane == null || !lane.isRecording()) continue;
            supress_candidates.remove(dev);
        }
        for (MidiDevice midiDevice : supress_candidates) {
            if (!(midiDevice instanceof SynthWrapper)) continue;
            ((SynthWrapper)midiDevice).setSupressAudio(true);
        }
        for (FrinikaDeviceRenderer frinikaDeviceRenderer : this.deviceRenderers) {
            frinikaDeviceRenderer.beforeStart();
        }
    }

    public void start() {
        for (FrinikaDeviceRenderer render : this.deviceRenderers) {
            render.start();
        }
    }

    public void stop() {
        if (!this.started) {
            return;
        }
        this.started = false;
        for (FrinikaDeviceRenderer render : this.deviceRenderers) {
            render.stop();
            if (!(render.dev instanceof SynthWrapper)) continue;
            ((SynthWrapper)render.dev).setSupressAudio(false);
        }
        this.deviceRenderers.clear();
    }

    public void close() {
        this.stop();
        this.seqr.removeSequencerListener(this);
    }

    public void purgeRenderCache() {
        File projectfile = this.project.getFile();
        File parentdir = projectfile.getParentFile();
        String name = projectfile.getName();
        if (name.toLowerCase().endsWith(".frinika")) {
            name = name.substring(0, name.length() - 8);
        }
        name = name + ".";
        String suffix = ".rendercache";
        File[] filelist = parentdir.listFiles();
        if (filelist != null) {
            for (File f : filelist) {
                if (!f.getName().startsWith(name) || !f.getName().endsWith(suffix)) continue;
                f.delete();
            }
        }
    }

    public void render(JFrame frame, long tickfrom, long tickto) {
        if (!this.anyLaneWithPreRendering()) {
            JOptionPane.showMessageDialog(frame, "No lane with prerender flag was found.", "Render Selected Timeline", 2);
            return;
        }
        this.rendermode = 1;
        new RenderDialog(frame, this.project, tickfrom, tickto);
        this.project.getSequencer().stop();
        this.rendermode = 0;
    }

    public void rerender(JFrame frame, long tickfrom, long tickto) {
        if (!this.anyLaneWithPreRendering()) {
            JOptionPane.showMessageDialog(frame, "No lane with prerender flag was found.", "Rerender Selected Timeline", 2);
            return;
        }
        this.rendermode = 2;
        new RenderDialog(frame, this.project, tickfrom, tickto);
        this.project.getSequencer().stop();
        this.rendermode = 0;
    }

    public void setSupressRealTime(boolean suppress_realtime) {
    }
}

