/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.renderer;

import com.frinika.renderer.FrinikaChannelRenderer;
import com.frinika.renderer.FrinikaRenderer;
import com.frinika.sequencer.FrinikaTrackWrapper;
import com.frinika.sequencer.gui.mixer.SynthWrapper;
import javax.sound.midi.MidiDevice;
import uk.org.toot.audio.core.AudioBuffer;
import uk.org.toot.audio.core.AudioProcess;

public class FrinikaDeviceRenderer {
    MidiDevice dev;
    FrinikaRenderer renderer;
    FrinikaChannelRenderer[] channels = new FrinikaChannelRenderer[16];
    AudioProcess renderProcess = new AudioProcess(){

        public void open() {
        }

        public int processAudio(AudioBuffer buffer) {
            int samplecount = buffer.getSampleCount();
            for (int i = 0; i < FrinikaDeviceRenderer.this.channels.length; ++i) {
                if (FrinikaDeviceRenderer.this.channels[i] == null) continue;
                FrinikaDeviceRenderer.this.channels[i].processAudio(buffer);
            }
            return 0;
        }

        public void close() {
        }
    };

    public FrinikaDeviceRenderer(FrinikaRenderer renderer, MidiDevice dev) {
        this.renderer = renderer;
        this.dev = dev;
    }

    public void addTrack(FrinikaTrackWrapper track) {
        int ch = track.getMidiChannel();
        if (this.channels[ch] == null) {
            this.channels[ch] = new FrinikaChannelRenderer(this, ch);
        }
        this.channels[ch].addTrack(track);
    }

    public MidiDevice getDevice() {
        return this.dev;
    }

    public void beforeStart() {
        int i;
        for (i = 0; i < this.channels.length; ++i) {
            if (this.channels[i] == null) continue;
            this.channels[i].beforeStart();
        }
        for (i = 0; i < this.channels.length; ++i) {
            if (this.channels[i] == null) continue;
            this.channels[i].beforeStart2();
        }
    }

    public void start() {
        if (this.dev instanceof SynthWrapper) {
            ((SynthWrapper)this.dev).setRenderAudioProcess(this.renderProcess);
        }
    }

    public void stop() {
        if (this.dev instanceof SynthWrapper) {
            ((SynthWrapper)this.dev).setRenderAudioProcess(null);
        }
        for (int i = 0; i < this.channels.length; ++i) {
            if (this.channels[i] == null) continue;
            this.channels[i].stop();
        }
    }
}

