/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.renderer;

import com.frinika.project.MidiDeviceDescriptor;
import com.frinika.renderer.CachedRender;
import com.frinika.renderer.FrinikaDeviceRenderer;
import com.frinika.renderer.FrinikaMidiPacketProvider;
import com.frinika.renderer.MidiRenderFactory;
import com.frinika.sequencer.FrinikaSequence;
import com.frinika.sequencer.FrinikaTrackWrapper;
import java.io.File;
import java.util.ArrayList;
import uk.org.toot.audio.core.AudioBuffer;

public class FrinikaChannelRenderer
implements Runnable {
    public static final long DEFAULT_PACKET_LENGTH = 1000000L;
    public static final int PREBUFFER_PACKET_COUNT = 3;
    int pipesize;
    int buffersize;
    long packetlen;
    FrinikaDeviceRenderer dev_render;
    int channel;
    ArrayList<FrinikaTrackWrapper> tracks = new ArrayList();
    FrinikaMidiPacketProvider packetprovider;
    Thread render_thread;
    CachedRender packet_render;
    volatile boolean active = false;
    int process_index;
    int process_index_bufferpos;
    float[] process_buffer;
    int current_index;
    int current_next_index;
    int current_render_index;
    float[][] circularbuffer;
    int circularbuffer_read_pos = 0;
    int circularbuffer_write_pos = 0;
    int circularbuffer_avail = 0;

    public FrinikaChannelRenderer(FrinikaDeviceRenderer dev_render, int channel) {
        this.dev_render = dev_render;
        this.channel = channel;
        this.packetlen = 1000000L;
        this.buffersize = 88200;
        this.pipesize = 3;
        this.circularbuffer = new float[this.pipesize][this.buffersize];
    }

    public void addTrack(FrinikaTrackWrapper track) {
        this.tracks.add(track);
    }

    public void beforeStart() {
        this.packetprovider = new FrinikaMidiPacketProvider(this.packetlen, this.dev_render.renderer.seqr, this.dev_render.renderer.project.getSequence(), this.tracks);
        FrinikaSequence seq = this.dev_render.renderer.project.getSequence();
        long recordStartTimeInMicros = this.dev_render.renderer.seqr.getMicrosecondPosition();
        this.process_index = (int)(recordStartTimeInMicros / 1000000L);
        this.process_index_bufferpos = (int)(44100.0 * ((double)(recordStartTimeInMicros % 1000000L) / 1000000.0)) * 2;
        this.current_render_index = (int)(recordStartTimeInMicros / 1000000L);
        this.current_index = -1;
        this.current_next_index = this.current_render_index;
        File projectfile = this.dev_render.renderer.project.getFile();
        String path = projectfile.getPath();
        if (path.toLowerCase().endsWith(".frinika")) {
            path = path.substring(0, path.length() - 8);
        }
        MidiDeviceDescriptor mdesc = this.dev_render.renderer.project.getMidiDeviceDescriptor(this.dev_render.dev);
        int d_id = this.dev_render.renderer.project.getMidiDeviceDescriptors().indexOf(mdesc);
        path = path + ".d" + d_id + "c" + this.channel + ".rendercache";
        File cachefile = new File(path);
        this.packet_render = new CachedRender(cachefile, this.packetprovider, (MidiRenderFactory)((Object)this.dev_render.dev), 44100.0f, 2, this.dev_render.renderer.rendermode);
        this.active = true;
        this.render_thread = new Thread(this);
        this.render_thread.setPriority(1);
        this.render_thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeStart2() {
        while (true) {
            FrinikaChannelRenderer frinikaChannelRenderer = this;
            synchronized (frinikaChannelRenderer) {
                if (this.circularbuffer_avail == this.pipesize) {
                    return;
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.active) {
            boolean pipefull = false;
            FrinikaChannelRenderer frinikaChannelRenderer = this;
            synchronized (frinikaChannelRenderer) {
                pipefull = this.circularbuffer_avail == this.pipesize;
            }
            if (pipefull) {
                try {
                    Thread.sleep(20L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    return;
                }
            }
            float[] buffer = this.circularbuffer[this.circularbuffer_write_pos];
            this.packet_render.getPacket(this.current_render_index, buffer, 0, this.buffersize);
            ++this.current_render_index;
            FrinikaChannelRenderer frinikaChannelRenderer2 = this;
            synchronized (frinikaChannelRenderer2) {
                this.circularbuffer_write_pos = (this.circularbuffer_write_pos + 1) % this.pipesize;
                ++this.circularbuffer_avail;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nextBuffer() {
        boolean pipeempty;
        if (this.process_buffer != null) {
            FrinikaChannelRenderer frinikaChannelRenderer = this;
            synchronized (frinikaChannelRenderer) {
                --this.circularbuffer_avail;
            }
        }
        do {
            FrinikaChannelRenderer frinikaChannelRenderer = this;
            synchronized (frinikaChannelRenderer) {
                pipeempty = this.circularbuffer_avail == 0;
            }
            if (!pipeempty) continue;
            try {
                System.out.println("Render Underflow");
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return;
            }
        } while (pipeempty);
        this.current_index = this.current_next_index++;
        float[] buffer = this.circularbuffer[this.circularbuffer_read_pos];
        this.circularbuffer_read_pos = (this.circularbuffer_read_pos + 1) % this.pipesize;
        this.process_buffer = buffer;
    }

    public void nextProcessBuffer() {
        this.nextBuffer();
        ++this.process_index;
        this.process_index_bufferpos = 0;
    }

    public void stop() {
        this.active = false;
        this.packet_render.close();
    }

    public void processAudio(AudioBuffer buffer) {
        float[] left = buffer.getChannel(0);
        float[] right = buffer.getChannel(1);
        int sampleCount = buffer.getSampleCount();
        int writeCount = 0;
        if (this.process_buffer == null) {
            this.nextBuffer();
        }
        while (sampleCount - writeCount != 0) {
            int avail;
            if (this.process_index_bufferpos == this.buffersize) {
                this.nextProcessBuffer();
            }
            if ((avail = (this.buffersize - this.process_index_bufferpos) / 2) > sampleCount - writeCount) {
                avail = sampleCount - writeCount;
            }
            for (int i = 0; i < avail; ++i) {
                int n = writeCount;
                left[n] = left[n] + this.process_buffer[this.process_index_bufferpos++];
                int n2 = writeCount++;
                right[n2] = right[n2] + this.process_buffer[this.process_index_bufferpos++];
            }
        }
    }
}

