/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.project.scripting.gui;

import com.frinika.project.scripting.DefaultFrinikaScript;
import com.frinika.project.scripting.FrinikaScript;
import com.frinika.project.scripting.FrinikaScriptingEngine;
import com.frinika.project.scripting.ScriptListener;
import com.frinika.project.scripting.gui.ScriptingDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;

class ScriptEditorInternalFrame
extends JInternalFrame
implements ScriptListener,
Runnable {
    final int EXTERNAL_CHANGE_TEST_INTERVAL = 250;
    protected FrinikaScript script;
    protected boolean dirty;
    protected ScriptingDialog dialog;
    protected long lastSaveTimestamp = 0L;
    private JEditorPane editorPane;
    private JPanel jPanel1;
    private JButton runButton;
    private JScrollPane scrollPane;
    private JButton stopButton;
    private JToolBar toolBar;

    public ScriptEditorInternalFrame(FrinikaScript script, ScriptingDialog dialog) {
        this.script = script;
        this.dialog = dialog;
        this.dirty = false;
        this.initComponents();
        if (!(script instanceof DefaultFrinikaScript)) {
            this.editorPane.setEditable(false);
            this.editorPane.setBackground(new Color(240, 240, 240));
        }
        this.getRootPane().setDefaultButton(this.runButton);
        this.scriptExited(script, null);
        this.refresh();
        FrinikaScriptingEngine cfr_ignored_0 = dialog.engine;
        FrinikaScriptingEngine.addScriptListener(this);
        if (script instanceof DefaultFrinikaScript) {
            File file;
            String filename = ((DefaultFrinikaScript)script).getFilename();
            if (filename != null && (file = new File(filename)).exists()) {
                this.lastSaveTimestamp = file.lastModified();
            }
            new Thread(this).start();
        }
    }

    public void toFront() {
        super.toFront();
        this.editorPane.requestFocus();
    }

    void setDirty(boolean d) {
        if (this.dirty != d) {
            this.dirty = d;
            this.updateTitle();
        }
    }

    boolean hasBeenModifiedWithoutSaving() {
        return this.dirty;
    }

    boolean hasBeenModifiedByExternalApplication() {
        if (this.script instanceof DefaultFrinikaScript) {
            if (this.lastSaveTimestamp > 0L) {
                String filename = ((DefaultFrinikaScript)this.script).getFilename();
                File file = new File(filename);
                return file.lastModified() != this.lastSaveTimestamp;
            }
            return false;
        }
        return false;
    }

    FrinikaScript getScript() {
        return this.script;
    }

    void setScript(FrinikaScript script) {
        this.script = script;
        this.refresh();
        this.setDirty(false);
    }

    void reload() {
        try {
            DefaultFrinikaScript script = (DefaultFrinikaScript)this.script;
            String filename = script.getFilename();
            File file = new File(filename);
            String source = FrinikaScriptingEngine.loadString(file);
            script.setSource(source);
            this.refresh();
            this.lastSaveTimestamp = file.lastModified();
            this.setDirty(false);
        }
        catch (IOException ioe) {
            this.dialog.frame.error(ioe);
        }
    }

    public void refresh() {
        this.editorPane.setText(this.script.getSource());
        this.updateTitle();
    }

    public void update() {
        if (this.script instanceof DefaultFrinikaScript) {
            ((DefaultFrinikaScript)this.script).setSource(this.editorPane.getText());
        }
    }

    protected void updateTitle() {
        String t = this.script.getName();
        if (this.dirty) {
            t = t + " *";
        }
        if (!t.equals(this.getTitle())) {
            this.setTitle(t);
            this.dialog.updateMenus();
        }
    }

    public void scriptStarted(FrinikaScript script) {
        if (script == this.script) {
            this.runButton.setEnabled(false);
            this.stopButton.setEnabled(true);
        }
    }

    public void scriptExited(FrinikaScript script, Object returnValue) {
        if (script == this.script) {
            this.runButton.setEnabled(true);
            this.stopButton.setEnabled(false);
        }
    }

    public void run() {
        String filename = ((DefaultFrinikaScript)this.script).getFilename();
        while (!this.isClosed()) {
            if (this.hasBeenModifiedByExternalApplication()) {
                if (this.dialog.frame.confirm("Script " + filename + " has been modified by an external application. Reload?")) {
                    if (!this.hasBeenModifiedWithoutSaving() || this.dialog.frame.confirm("This will DESTROY local changes. Reload anyway?")) {
                        this.reload();
                    }
                } else {
                    this.lastSaveTimestamp = 0L;
                    this.setDirty(true);
                }
            }
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.editorPane = new JEditorPane();
        this.toolBar = new JToolBar();
        this.jPanel1 = new JPanel();
        this.runButton = new JButton();
        this.stopButton = new JButton();
        this.setClosable(true);
        this.setDefaultCloseOperation(0);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.editorPane.setFont(new Font("DialogInput", 0, 12));
        this.editorPane.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                ScriptEditorInternalFrame.this.editorPaneFocusLost(evt);
            }
        });
        this.editorPane.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                ScriptEditorInternalFrame.this.editorPaneKeyPressed(evt);
            }

            public void keyTyped(KeyEvent evt) {
                ScriptEditorInternalFrame.this.editorPaneKeyTyped(evt);
            }
        });
        this.scrollPane.setViewportView(this.editorPane);
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.jPanel1.setLayout(new FlowLayout(0, 1, 0));
        this.runButton.setIcon(new ImageIcon(ClassLoader.getSystemResource("icons/play.png")));
        this.runButton.setToolTipText("Ctrl-Enter");
        this.runButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ScriptEditorInternalFrame.this.runButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.runButton);
        this.stopButton.setIcon(new ImageIcon(ClassLoader.getSystemResource("icons/stop.png")));
        this.stopButton.setMnemonic('S');
        this.stopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ScriptEditorInternalFrame.this.stopButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.stopButton);
        this.toolBar.add(this.jPanel1);
        this.getContentPane().add((Component)this.toolBar, "North");
        this.pack();
    }

    private void editorPaneKeyPressed(KeyEvent evt) {
        if (!this.editorPane.isEditable()) {
            return;
        }
        if (evt.isControlDown() && evt.getKeyCode() == 10) {
            this.runButton.doClick();
            evt.consume();
        }
    }

    private void editorPaneKeyTyped(KeyEvent evt) {
        this.setDirty(true);
    }

    private void editorPaneFocusLost(FocusEvent evt) {
        this.update();
    }

    private void runButtonActionPerformed(ActionEvent evt) {
        this.update();
        this.dialog.executeScript(this.script);
    }

    private void stopButtonActionPerformed(ActionEvent evt) {
        this.dialog.stopScript(this.script);
    }
}

