/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.project;

import com.frinika.project.MidiDeviceDescriptor;
import com.frinika.project.ProjectContainer;
import com.frinika.sequencer.gui.mixer.SynthWrapper;
import java.io.File;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;

public class SynthesizerDescriptor
extends MidiDeviceDescriptor {
    private static final long serialVersionUID = 1L;
    String soundBankFileName;

    public SynthesizerDescriptor(Synthesizer midiDevice) {
        super(midiDevice);
    }

    public String getSoundBankFileName() {
        return this.soundBankFileName;
    }

    public void setSoundBankFileName(String soundBankFileName) {
        this.soundBankFileName = soundBankFileName;
    }

    protected void installImp(ProjectContainer project) {
        super.installImp(project);
        if (this.soundBankFileName != null) {
            try {
                Soundbank soundbank = this.midiDevice instanceof SynthWrapper ? ((SynthWrapper)this.midiDevice).getSoundbank(new File(this.soundBankFileName)) : MidiSystem.getSoundbank(new File(this.soundBankFileName));
                ((Synthesizer)this.midiDevice).loadAllInstruments(soundbank);
                System.out.println("Soundbank loaded");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

