/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.project;

import com.frinika.project.ProjectContainer;
import com.frinika.project.gui.ProjectFrame;
import com.frinika.sequencer.gui.mixer.MidiDeviceIconProvider;
import com.frinika.sequencer.gui.mixer.SynthWrapper;
import com.frinika.sequencer.model.Lane;
import com.frinika.sequencer.model.SynthLane;
import com.frinika.synth.SynthRack;
import java.io.Serializable;
import java.lang.reflect.Method;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.swing.Icon;

public class MidiDeviceDescriptor
implements Serializable,
MidiDeviceIconProvider {
    private static final long serialVersionUID = 1L;
    String midiDeviceName;
    String projectName;
    protected Serializable serializableMidiDevice = null;
    transient MidiDevice midiDevice;
    private transient boolean isInstalled = false;

    public MidiDeviceDescriptor(MidiDevice midiDevice) {
        SynthWrapper synthwrapper;
        this.midiDevice = midiDevice;
        this.projectName = this.midiDeviceName = midiDevice.getDeviceInfo().getName();
        if (midiDevice instanceof SynthWrapper && (synthwrapper = (SynthWrapper)midiDevice).getRealDevice() instanceof Serializable) {
            this.serializableMidiDevice = (Serializable)((Object)synthwrapper.getRealDevice());
        }
    }

    public String getMidiDeviceName() {
        return this.midiDeviceName;
    }

    public void setMidiDeviceName(String midiDeviceName) {
        this.midiDeviceName = midiDeviceName;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
        if (this.midiDevice instanceof SynthWrapper) {
            SynthWrapper synthwrapper = (SynthWrapper)this.midiDevice;
            MidiDevice realdevice = synthwrapper.getRealDevice();
            try {
                Method setName = realdevice.getClass().getMethod("setName", String.class);
                setName.invoke((Object)realdevice, projectName);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public final void install(ProjectContainer project) {
        SynthWrapper synthwrapper;
        if (this.isInstalled) {
            return;
        }
        if (this.serializableMidiDevice != null && this.serializableMidiDevice instanceof MidiDevice) {
            this.midiDevice = new SynthWrapper(project, (MidiDevice)((Object)this.serializableMidiDevice));
            try {
                this.midiDevice.open();
                project.loadMidiOutDevice(this);
                this.isInstalled = true;
                this.attachToSynthLane(project);
                return;
            }
            catch (MidiUnavailableException e) {
                System.out.println(" Failed to open MidiDevice " + this.midiDeviceName);
                e.printStackTrace();
            }
        }
        this.installImp(project);
        this.isInstalled = true;
        if (this.midiDevice instanceof SynthWrapper && (synthwrapper = (SynthWrapper)this.midiDevice).getRealDevice() instanceof Serializable) {
            this.serializableMidiDevice = (Serializable)((Object)synthwrapper.getRealDevice());
        }
        this.attachToSynthLane(project);
        this.setProjectName(this.projectName);
    }

    private void attachToSynthLane(ProjectContainer project) {
        boolean found = false;
        for (Lane lane : project.projectLane.getChildren()) {
            SynthLane sl;
            if (!(lane instanceof SynthLane) || (sl = (SynthLane)lane).getMidiDescriptor() != this || !sl.install(this)) continue;
            MidiDevice dev = sl.getMidiDescriptor().getMidiDevice();
            if (dev instanceof SynthWrapper && ((SynthWrapper)dev).getAudioProcess() != null || dev instanceof SynthRack) {
                sl.attachAudioProcessToMixer();
            }
            found = true;
            break;
        }
        if (!found) {
            System.out.println("Unable to find a SynthLane for synth " + this.midiDevice);
            SynthLane lane = project.createSynthLane(this);
            lane.attachAudioProcessToMixer();
        }
    }

    protected void installImp(ProjectContainer project) {
        MidiDevice dev = null;
        try {
            for (MidiDevice.Info info : MidiSystem.getMidiDeviceInfo()) {
                if (!info.getName().equals(this.midiDeviceName)) continue;
                dev = MidiSystem.getMidiDevice(info);
                if (dev.getMaxReceivers() != 0) break;
                dev = null;
            }
            if (dev == null) {
                System.out.println(" Failed to find MidiDevice " + this.midiDeviceName);
            } else {
                this.midiDevice = new SynthWrapper(project, dev);
                project.loadMidiOutDevice(this);
            }
        }
        catch (MidiUnavailableException e) {
            System.out.println(" Failed to open MidiDevice " + this.midiDeviceName);
            e.printStackTrace();
        }
    }

    public MidiDevice getMidiDevice() {
        return this.midiDevice;
    }

    public Serializable getSerializableMidiDevice() {
        return this.serializableMidiDevice;
    }

    public String toString() {
        return this.getProjectName() + " (" + this.getMidiDeviceName() + ")";
    }

    public Icon getIcon() {
        return ProjectFrame.getMidiDeviceIcon(this.midiDevice);
    }

    public Icon getLargeIcon() {
        return ProjectFrame.getMidiDeviceLargeIcon(this.midiDevice);
    }
}

