/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.notation;

import com.frinika.notation.NotationEditor;
import com.frinika.sequencer.model.MidiLane;
import com.frinika.sequencer.model.MidiPart;
import com.frinika.sequencer.model.MultiEvent;
import com.frinika.sequencer.model.notation.ClefChange;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Iterator;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class NotationHeader
extends JPanel
implements MouseListener,
AdjustmentListener {
    private static final long serialVersionUID = 1L;
    private int yScroll;
    public NotationEditor notationEditor;
    MidiLane selectedlane = null;

    public NotationHeader(NotationEditor notationEditor, int timePanelHeight, int value) {
        this.notationEditor = notationEditor;
        int width = 135;
        int yBot = 100;
        this.setSize(new Dimension(width, yBot));
        this.setPreferredSize(new Dimension(width, yBot));
        this.setMaximumSize(new Dimension(width, 20000));
        this.setBackground(Color.WHITE);
        this.addMouseListener(this);
        this.enableEvents(16L);
    }

    public void setClef(int clef, int pos) {
        if (this.selectedlane != null) {
            MultiEvent event;
            MidiPart head = this.selectedlane.getHeadPart();
            ClefChange clef_event = null;
            Iterator iter = head.getMultiEvents().iterator();
            while (iter.hasNext() && (event = (MultiEvent)iter.next()).getStartTick() <= 0L) {
                if (!(event instanceof ClefChange)) continue;
                clef_event = (ClefChange)event;
                break;
            }
            if (clef_event == null) {
                clef_event = new ClefChange(head, 0L);
                head.add(clef_event);
            }
            clef_event.clef_type = clef;
            clef_event.clef_pos = pos;
            clef_event.clef_octave = 0;
            this.notationEditor.repaintItems();
        }
    }

    public void showPopup(MouseEvent event) {
        MidiLane lane = this.notationEditor.getLaneAtY(event.getY() - 20 + this.yScroll);
        if (lane == null) {
            return;
        }
        if (event.getX() > 45) {
            return;
        }
        this.selectedlane = lane;
        JPopupMenu popupmenu = new JPopupMenu();
        JMenuItem menuitem = new JMenuItem("Treble Clef (G)");
        menuitem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NotationHeader.this.setClef(7, 2);
            }
        });
        popupmenu.add(menuitem);
        menuitem = new JMenuItem("Bass Clef (F)");
        menuitem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NotationHeader.this.setClef(-7, 6);
            }
        });
        popupmenu.add(menuitem);
        menuitem = new JMenuItem("Alto Clef (C)");
        menuitem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NotationHeader.this.setClef(0, 4);
            }
        });
        popupmenu.add(menuitem);
        menuitem = new JMenuItem("Tenor Clef (C)");
        menuitem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NotationHeader.this.setClef(0, 6);
            }
        });
        popupmenu.add(menuitem);
        popupmenu.show(event.getComponent(), event.getX(), event.getY());
    }

    public void processMouseEvent(MouseEvent event) {
        if (event.isPopupTrigger()) {
            this.showPopup(event);
        }
        super.processMouseEvent(event);
    }

    public void mouseClicked(MouseEvent event) {
        this.showPopup(event);
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.notationEditor.paintHeader(g, this.yScroll);
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.yScroll = e.getValue();
        this.repaint();
    }
}

