/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.midi;

import com.frinika.global.FrinikaConfig;
import java.util.Vector;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Receiver;

public class MidiInDeviceManager {
    static Receiver active_receiver = null;
    static boolean isOpen = false;
    static Vector<MidiDevice> active_midiindevices = new Vector();
    static Receiver global_receiver = new Receiver(){

        public void send(MidiMessage message, long timeStamp) {
            if (active_receiver != null) {
                active_receiver.send(message, timeStamp);
            }
        }

        public void close() {
        }
    };

    public static void open() {
        MidiDevice.Info[] infos;
        if (isOpen) {
            return;
        }
        Vector<String> names = new Vector<String>();
        for (String name : FrinikaConfig.getMidiInDeviceList()) {
            names.add(name);
        }
        for (MidiDevice.Info info : infos = MidiSystem.getMidiDeviceInfo()) {
            String str = info.toString();
            if (!names.contains(str)) continue;
            try {
                MidiDevice dev = MidiSystem.getMidiDevice(info);
                if (dev.getMaxTransmitters() == 0) continue;
                dev.open();
                dev.getTransmitter().setReceiver(global_receiver);
                active_midiindevices.add(dev);
            }
            catch (Throwable e1) {
                e1.printStackTrace();
            }
        }
        isOpen = true;
    }

    public static void setReceiver(Receiver receiver) {
        active_receiver = receiver;
    }

    public static void reset() {
        if (!isOpen) {
            return;
        }
        MidiInDeviceManager.close();
        MidiInDeviceManager.open();
    }

    public static void close() {
        if (!isOpen) {
            return;
        }
        for (MidiDevice dev : active_midiindevices) {
            try {
                dev.close();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        active_midiindevices.clear();
        isOpen = false;
    }

    public static MidiDevice getMidiInDevice() {
        MidiDevice.Info[] infos;
        String name = FrinikaConfig.getMidiInDeviceList().get(0);
        for (MidiDevice.Info info : infos = MidiSystem.getMidiDeviceInfo()) {
            String str = info.toString();
            if (!name.equals(str)) continue;
            try {
                MidiDevice dev = MidiSystem.getMidiDevice(info);
                return dev;
            }
            catch (Throwable e1) {
                e1.printStackTrace();
            }
        }
        return null;
    }
}

