/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.midi;

import com.frinika.midi.DrumMapper;
import com.frinika.midi.DrumMapperPanel;
import com.frinika.project.MidiDeviceDescriptor;
import com.frinika.project.ProjectContainer;
import com.frinika.sequencer.gui.ListProvider;
import com.frinika.sequencer.gui.PopupClient;
import com.frinika.sequencer.gui.PopupSelectorButton;
import com.frinika.sequencer.gui.pianoroll.VirtualPianoVert;
import com.frinika.sequencer.model.MidiLane;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class DrumMapperGUI
extends JPanel {
    DrumMapper dm;
    ProjectContainer proj;
    VirtualPianoVert inPiano;
    VirtualPianoVert outPiano;
    VirtualPianoVert.Config configIn = null;
    VirtualPianoVert.Config configOut = null;
    JButton setMap;
    MidiLane lane;

    DrumMapperGUI(final DrumMapper dm, ProjectContainer proj, MidiLane lane) {
        this.dm = dm;
        this.lane = lane;
        this.proj = proj;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 0;
        gc.anchor = 17;
        try {
            this.configIn = new VirtualPianoVert.Config(40, 8, dm.getReceiver(), lane);
        }
        catch (MidiUnavailableException e) {
            e.printStackTrace();
        }
        this.inPiano = new VirtualPianoVert(this.configIn);
        try {
            MidiDevice dev = dm.getDefaultMidiDevice();
            Receiver recv = null;
            if (dev != null) {
                recv = dev.getReceiver();
            }
            this.configOut = new VirtualPianoVert.Config(50, 8, recv, lane);
        }
        catch (MidiUnavailableException e) {
            e.printStackTrace();
        }
        this.outPiano = new VirtualPianoVert(this.configOut);
        this.setMap = new JButton(" -- assign key --> ");
        this.setMap.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                int in = DrumMapperGUI.this.inPiano.getLastKeytPress();
                int out = DrumMapperGUI.this.outPiano.getLastKeytPress();
                dm.setMapping(in, out);
                DrumMapperGUI.this.repaint();
            }
        });
        gc.fill = 1;
        this.add((Component)this.setMap, gc);
        DrumMapperPanel pianoPanel = new DrumMapperPanel(this.inPiano, this.outPiano, dm);
        ++gc.gridy;
        JScrollPane scroll = new JScrollPane(pianoPanel);
        gc.fill = 1;
        gc.weighty = 1.0;
        gc.weightx = 1.0;
        this.add((Component)scroll, gc);
    }

    void init() {
        MidiDevice dev = this.dm.getDefaultMidiDevice();
        Receiver recv = null;
        if (dev != null) {
            try {
                recv = dev.getReceiver();
            }
            catch (MidiUnavailableException e) {
                e.printStackTrace();
            }
        }
        this.configOut.setReceiver(recv);
    }

    PopupSelectorButton createDeviceSelector() {
        MidiDevice midiDev = this.dm.getDefaultMidiDevice();
        ListProvider resource = new ListProvider(){

            public Object[] getList() {
                return DrumMapperGUI.this.proj.getMidiDeviceDescriptors().toArray();
            }
        };
        PopupClient client = new PopupClient(){

            public void fireSelected(PopupSelectorButton but, Object o, int cnt) {
                DrumMapperGUI.this.dm.setDefaultMidiDevice(((MidiDeviceDescriptor)o).getMidiDevice());
                DrumMapperGUI.this.init();
            }
        };
        String name = midiDev != null ? midiDev.toString() : "null";
        return new PopupSelectorButton(resource, client, name);
    }
}

