/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.gui.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;

public class PropertiesEditor
extends JPanel
implements TableModelListener {
    private static final long serialVersionUID = 1L;
    protected Properties properties;
    private JButton addButton;
    private JPanel buttonsPanel;
    private JTable propertiesTable;
    private JButton removeButton;
    private JScrollPane scrollPane;

    public PropertiesEditor() {
        this.initComponents();
    }

    public PropertiesEditor(Properties p) {
        this();
        this.setProperties(p);
    }

    public void setProperties(Properties p) {
        this.properties = p;
        this.updateModel();
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void tableChanged(TableModelEvent e) {
        int index = e.getFirstRow();
        String key = this.propertiesTable.getModel().getValueAt(index, 0).toString();
        String value = this.propertiesTable.getModel().getValueAt(index, 1).toString();
        this.properties.setProperty(key, value);
    }

    protected void updateModel() {
        DefaultTableModel model = new DefaultTableModel(this.propertiesToArray(this.properties), new String[]{"Parameter", "Value"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class};
                this.canEdit = new boolean[]{false, true};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        };
        model.addTableModelListener(this);
        this.propertiesTable.setModel(model);
    }

    protected Object[][] propertiesToArray(Properties p) {
        Object[][] o = new Object[p.size()][2];
        int i = 0;
        for (Map.Entry<Object, Object> e : p.entrySet()) {
            o[i][0] = e.getKey();
            o[i][1] = e.getValue();
            ++i;
        }
        return o;
    }

    private void initComponents() {
        this.buttonsPanel = new JPanel();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.scrollPane = new JScrollPane();
        this.propertiesTable = new JTable();
        this.setLayout(new BorderLayout());
        this.buttonsPanel.setLayout(new GridBagLayout());
        this.addButton.setText("Add...");
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PropertiesEditor.this.addButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.buttonsPanel.add((Component)this.addButton, gridBagConstraints);
        this.removeButton.setText("Remove");
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PropertiesEditor.this.removeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.buttonsPanel.add((Component)this.removeButton, gridBagConstraints);
        this.add((Component)this.buttonsPanel, "East");
        this.propertiesTable.setModel(new DefaultTableModel(new Object[][]{{null, null}}, new String[]{"Audio Parameter", "Value"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, true};
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.scrollPane.setViewportView(this.propertiesTable);
        this.add((Component)this.scrollPane, "Center");
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        String newKey = JOptionPane.showInputDialog("Name of a new entry to add:").toString();
        if (newKey != null && this.properties.get(newKey) == null) {
            this.properties.put(newKey, "");
            this.updateModel();
        }
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        Object o;
        int index = this.propertiesTable.getSelectedRow();
        if (index >= 0 && (o = this.propertiesTable.getModel().getValueAt(index, 0)) != null && JOptionPane.showConfirmDialog(this, "Remove entry '" + o.toString() + "'?", "Remove configuration entry", 2) == 0) {
            this.properties.remove(o);
            this.updateModel();
        }
    }
}

