/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.gui.util;

import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FontChooser
extends JDialog {
    String[] styleList = new String[]{"Plain", "Bold", "Italic", "Bold-Italic"};
    String[] sizeList = new String[]{"3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "22", "24", "27", "30", "34", "39", "45", "51", "60"};
    NwList StyleList;
    NwList FontList;
    NwList SizeList;
    static JLabel Sample = new JLabel();
    boolean ob = false;

    private FontChooser(Frame parent, boolean modal, Font font) {
        super(parent, modal);
        this.initAll();
        this.setTitle("Font Chooser");
        if (font == null) {
            font = Sample.getFont();
        }
        this.FontList.setSelectedItem(font.getName());
        this.SizeList.setSelectedItem(font.getSize() + "");
        this.StyleList.setSelectedItem(this.styleList[font.getStyle()]);
    }

    public static Font showDialog(Frame parent, String s, Font font) {
        FontChooser fd = new FontChooser(parent, true, font);
        if (s != null) {
            fd.setTitle(s);
        }
        fd.setVisible(true);
        Font fo = null;
        if (fd.ob) {
            fo = Sample.getFont();
        }
        fd.dispose();
        return fo;
    }

    private void initAll() {
        this.getContentPane().setLayout(null);
        this.setBounds(150, 150, 425, 425);
        this.addLists();
        this.addButtons();
        Sample.setBounds(10, 320, 415, 25);
        Sample.setForeground(Color.black);
        this.getContentPane().add(Sample);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                FontChooser.this.setVisible(false);
            }
        });
    }

    private void addLists() {
        this.FontList = new NwList(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
        this.StyleList = new NwList(this.styleList);
        this.SizeList = new NwList(this.sizeList);
        this.FontList.setBounds(10, 10, 260, 295);
        this.StyleList.setBounds(280, 10, 80, 295);
        this.SizeList.setBounds(370, 10, 40, 295);
        this.getContentPane().add(this.FontList);
        this.getContentPane().add(this.StyleList);
        this.getContentPane().add(this.SizeList);
    }

    private void addButtons() {
        JButton ok = new JButton("Ok");
        JButton ca = new JButton("Cancel");
        ok.setBounds(260, 350, 70, 20);
        ca.setBounds(340, 350, 70, 20);
        this.getContentPane().add(ok);
        this.getContentPane().add(ca);
        this.getRootPane().setDefaultButton(ok);
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FontChooser.this.setVisible(false);
                FontChooser.this.ob = true;
            }
        });
        ca.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FontChooser.this.setVisible(false);
                FontChooser.this.ob = false;
            }
        });
    }

    private void showSample() {
        int g = 0;
        try {
            g = Integer.parseInt(this.SizeList.getSelectedValue());
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        String st = this.StyleList.getSelectedValue();
        int s = 0;
        int i = 0;
        for (String stl : this.styleList) {
            if (stl.equalsIgnoreCase(st)) {
                s = i;
            }
            ++i;
        }
        Sample.setFont(new Font(this.FontList.getSelectedValue(), s, g));
        Sample.setText("The quick brown fox jumped over the lazy dog.");
    }

    public class NwList
    extends JPanel {
        JList jl;
        JScrollPane sp;
        JLabel jt;
        String si = " ";

        public NwList(String[] values) {
            this.setLayout(null);
            this.jl = new JList<String>(values);
            this.sp = new JScrollPane(this.jl);
            this.jt = new JLabel();
            this.jt.setBackground(Color.white);
            this.jt.setForeground(Color.black);
            this.jt.setOpaque(true);
            this.jt.setBorder(new JTextField().getBorder());
            this.jt.setFont(this.getFont());
            this.jl.setBounds(0, 0, 100, 1000);
            this.jl.setBackground(Color.white);
            this.jl.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    NwList.this.jt.setText((String)NwList.this.jl.getSelectedValue());
                    NwList.this.si = (String)NwList.this.jl.getSelectedValue();
                    FontChooser.this.showSample();
                }
            });
            this.add(this.sp);
            this.add(this.jt);
        }

        public String getSelectedValue() {
            return this.si;
        }

        public void setSelectedItem(String s) {
            this.jl.setSelectedValue(s, true);
        }

        public void setBounds(int x, int y, int w, int h) {
            super.setBounds(x, y, w, h);
            this.sp.setBounds(0, y + 12, w, h - 23);
            this.sp.revalidate();
            this.jt.setBounds(0, 0, w, 20);
        }
    }
}

