/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.gui;

import com.frinika.global.ConfigError;
import com.frinika.global.FrinikaConfig;
import com.frinika.gui.OptionsBinder;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.ListModel;
import javax.swing.SpinnerNumberModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultOptionsBinder
implements OptionsBinder {
    protected Map<Field, Object> bindMap;
    protected Map<String, Object> dynamicBindMap;
    protected Properties properties;
    protected Object bindInstance = null;
    protected Map<Field, Object> back;

    public DefaultOptionsBinder(Map<Field, Object> bindMap, Map<String, Object> dynamicBindMap, Properties properties) {
        this.bindMap = bindMap;
        this.dynamicBindMap = dynamicBindMap;
        this.properties = properties;
    }

    public DefaultOptionsBinder(Map<Field, Object> bindMap, Properties properties) {
        this(bindMap, null, properties);
    }

    public Object getBindInstance() {
        return this.bindInstance;
    }

    public void setBindInstance(Object bindInstance) {
        this.bindInstance = bindInstance;
    }

    protected void toGUI(Object component, Object value, String fieldName) {
        if (component == null || value == null) {
            return;
        }
        if (component instanceof JTextField) {
            GUIAbstractionText gui = new GUIAbstractionText(component);
            String s = FrinikaConfig.valueToString(value, fieldName, value.getClass());
            if (s == null) {
                s = "";
            }
            ((GUIAbstraction)gui).setValue(s);
        } else if (component instanceof JCheckBox || component instanceof JToggleButton) {
            GUIAbstractionBoolean gui = new GUIAbstractionBoolean(component);
            boolean b = FrinikaConfig.isTrue(value);
            ((GUIAbstraction)gui).setValue(b);
        } else if (component instanceof JSpinner && ((JSpinner)component).getModel() instanceof SpinnerNumberModel || component instanceof JSlider) {
            GUIAbstractionNumber gui = new GUIAbstractionNumber(component);
            Class numberType = gui.getNumberType();
            if (value instanceof Number) {
                Number num = (Number)value;
                if (numberType == Integer.TYPE) {
                    ((GUIAbstraction)gui).setValue(num.intValue());
                } else if (numberType == Long.TYPE) {
                    ((GUIAbstraction)gui).setValue(num.longValue());
                } else if (numberType == Float.TYPE) {
                    ((GUIAbstraction)gui).setValue(Float.valueOf(num.floatValue()));
                } else {
                    ((GUIAbstraction)gui).setValue(num.doubleValue());
                }
            } else {
                String s = value.toString();
                if (numberType == Integer.TYPE) {
                    ((GUIAbstraction)gui).setValue(Integer.parseInt(s));
                } else if (numberType == Long.TYPE) {
                    ((GUIAbstraction)gui).setValue(Long.parseLong(s));
                } else if (numberType == Float.TYPE) {
                    ((GUIAbstraction)gui).setValue(Float.valueOf(Float.parseFloat(s)));
                } else {
                    ((GUIAbstraction)gui).setValue(Double.parseDouble(s));
                }
            }
        } else if (component instanceof JComboBox || component instanceof JList || component instanceof ButtonGroup) {
            GUIAbstractionSet gui = new GUIAbstractionSet(component);
            Object valueToBeSet = null;
            String s = value.toString();
            for (Object o : gui.getValues()) {
                if (!s.equals(o.toString())) continue;
                valueToBeSet = o;
            }
            if (valueToBeSet == null && component instanceof JComboBox && ((JComboBox)component).isEditable()) {
                valueToBeSet = value;
            }
            ((GUIAbstraction)gui).setValue(valueToBeSet);
        } else {
            throw new ConfigError("unsupported gui element for binding: " + component.getClass().getName());
        }
    }

    protected Object fromGUI(Object component, String fieldName, Class fieldType) {
        if (component instanceof JTextField) {
            GUIAbstractionText gui = new GUIAbstractionText(component);
            String s = (String)((GUIAbstraction)gui).getValue();
            return FrinikaConfig.stringToValue(s, fieldName, fieldType);
        }
        if (component instanceof JCheckBox || component instanceof JToggleButton) {
            GUIAbstractionBoolean gui = new GUIAbstractionBoolean(component);
            boolean b = (Boolean)((GUIAbstraction)gui).getValue();
            if (Boolean.TYPE.isAssignableFrom(fieldType)) {
                return b;
            }
            if (String.class.isAssignableFrom(fieldType)) {
                return b ? "yes" : "no";
            }
            if (Integer.TYPE.isAssignableFrom(fieldType)) {
                return b ? 1 : 0;
            }
            throw new ConfigError("unsupported gui binding: JCheckBox - " + fieldType.getName());
        }
        if (component instanceof JSpinner && ((JSpinner)component).getModel() instanceof SpinnerNumberModel || component instanceof JSlider) {
            GUIAbstractionNumber gui = new GUIAbstractionNumber(component);
            Number num = (Number)((GUIAbstraction)gui).getValue();
            if (Integer.TYPE.isAssignableFrom(fieldType)) {
                return num.intValue();
            }
            if (Long.TYPE.isAssignableFrom(fieldType)) {
                return num.longValue();
            }
            if (Float.TYPE.isAssignableFrom(fieldType)) {
                return Float.valueOf(num.floatValue());
            }
            if (Double.TYPE.isAssignableFrom(fieldType)) {
                return num.doubleValue();
            }
            if (Boolean.TYPE.isAssignableFrom(fieldType)) {
                return num.intValue() != 0;
            }
            if (String.class.isAssignableFrom(fieldType)) {
                return num.toString();
            }
            throw new ConfigError("unsupported gui binding: JSpinner - (number value+)" + fieldType.getName());
        }
        if (component instanceof JComboBox || component instanceof JList || component instanceof ButtonGroup) {
            GUIAbstractionSet gui = new GUIAbstractionSet(component);
            Object value = ((GUIAbstraction)gui).getValue();
            if (String.class.isAssignableFrom(fieldType)) {
                return value != null ? value.toString() : null;
            }
            if (fieldType.isPrimitive()) {
                return FrinikaConfig.stringToValue(value.toString(), fieldName, fieldType);
            }
            return value;
        }
        throw new ConfigError("unsupported gui element for binding: " + component.getClass().getName());
    }

    @Override
    public void refresh() {
        Object value;
        Object component;
        for (Map.Entry<Field, Object> entry : this.bindMap.entrySet()) {
            Field field = entry.getKey();
            component = entry.getValue();
            try {
                value = field.get(this.bindInstance);
                this.toGUI(component, value, field.getName());
            }
            catch (IllegalAccessException iae) {
                System.err.println("error refreshing GUI from field " + field.getName());
            }
        }
        if (this.dynamicBindMap != null) {
            for (Map.Entry<Object, Object> entry : this.dynamicBindMap.entrySet()) {
                String key = (String)entry.getKey();
                component = entry.getValue();
                value = this.properties.get(key);
                this.toGUI(component, value, key);
            }
        }
    }

    @Override
    public void update() {
        Object value;
        Object component;
        for (Map.Entry<Field, Object> entry : this.bindMap.entrySet()) {
            Field field = entry.getKey();
            component = entry.getValue();
            if (component == null) continue;
            value = this.fromGUI(component, field.getName(), field.getType());
            FrinikaConfig.setFieldValue(field, value);
        }
        if (this.dynamicBindMap != null) {
            for (Map.Entry<Object, Object> entry : this.dynamicBindMap.entrySet()) {
                String key = (String)entry.getKey();
                component = entry.getValue();
                value = this.fromGUI(component, key, String.class);
                String val = FrinikaConfig.valueToString(value, key, String.class);
                if (val == null) continue;
                this.properties.setProperty(key, val);
            }
        }
    }

    @Override
    public void backup() {
        this.back = new HashMap<Field, Object>();
        for (Field f : this.bindMap.keySet()) {
            try {
                this.back.put(f, f.get(this.bindInstance));
            }
            catch (IllegalAccessException iae) {
                System.err.println("error reading field " + f.getName());
            }
        }
    }

    @Override
    public void restore() {
        for (Field f : this.bindMap.keySet()) {
            Object o = this.back.get(f);
            try {
                if (f.getDeclaringClass() == FrinikaConfig.class) {
                    FrinikaConfig.setFieldValue(f, o);
                    continue;
                }
                f.set(this.bindInstance, o);
            }
            catch (IllegalAccessException iae) {
                System.err.println("error writing field " + f.getName());
            }
        }
    }

    class GUIAbstractionBoolean
    extends GUIAbstraction {
        private JCheckBox checkbox;
        private JToggleButton togglebutton;

        GUIAbstractionBoolean(Object component) {
            this.checkbox = null;
            this.togglebutton = null;
            if (component instanceof JCheckBox) {
                this.checkbox = (JCheckBox)component;
            } else if (component instanceof JToggleButton) {
                this.togglebutton = (JToggleButton)component;
            } else {
                throw new IllegalArgumentException("GUIAbstractionBoolean must be constructed with JCheckBox or JToggleButton, is " + component.getClass().getName());
            }
        }

        Object getValue() {
            if (this.checkbox != null) {
                return this.checkbox.isSelected();
            }
            return this.togglebutton.isSelected();
        }

        void setValue(Object o) {
            boolean b = FrinikaConfig.isTrue(o);
            if (this.checkbox != null) {
                this.checkbox.setSelected(b);
            } else {
                this.togglebutton.setSelected(b);
            }
        }
    }

    class GUIAbstractionSet
    extends GUIAbstraction {
        private JComboBox combobox;
        private JList list;
        private ButtonGroup buttongroup;

        GUIAbstractionSet(Object component) {
            this.combobox = null;
            this.list = null;
            this.buttongroup = null;
            if (component instanceof JComboBox) {
                this.combobox = (JComboBox)component;
            } else if (component instanceof JList) {
                this.list = (JList)component;
            } else if (component instanceof ButtonGroup) {
                this.buttongroup = (ButtonGroup)component;
            } else {
                throw new IllegalArgumentException("GUIAbstractionSet must be constructed with JComboBox, JList or ButtonGroup, is " + component.getClass().getName());
            }
        }

        Object getValue() {
            if (this.combobox != null) {
                return this.combobox.getSelectedItem();
            }
            if (this.list != null) {
                return this.list.getSelectedValue();
            }
            return ((AbstractButton)((Object)this.buttongroup.getSelection())).getName();
        }

        void setValue(Object value) {
            if (this.combobox != null) {
                this.combobox.setSelectedItem(value);
            } else if (this.list != null) {
                this.list.setSelectedValue(value, true);
            } else {
                if (value != null && !(value instanceof String)) {
                    value = value.toString();
                }
                Enumeration<AbstractButton> e = this.buttongroup.getElements();
                while (e.hasMoreElements()) {
                    AbstractButton ab = e.nextElement();
                    ab.setSelected(ab.getName().equals(value));
                }
            }
        }

        Collection getValues() {
            if (this.combobox != null) {
                ArrayList a = new ArrayList();
                for (int i = 0; i < this.combobox.getItemCount(); ++i) {
                    a.add(this.combobox.getItemAt(i));
                }
                return a;
            }
            if (this.list != null) {
                ListModel model = this.list.getModel();
                ArrayList a = new ArrayList();
                for (int i = 0; i < model.getSize(); ++i) {
                    a.add(model.getElementAt(i));
                }
                return a;
            }
            ArrayList<String> a = new ArrayList<String>();
            Enumeration<AbstractButton> e = this.buttongroup.getElements();
            while (e.hasMoreElements()) {
                AbstractButton ab = e.nextElement();
                a.add(ab.getName());
            }
            return a;
        }
    }

    class GUIAbstractionNumber
    extends GUIAbstraction {
        private JSpinner spinner;
        private JSlider slider;

        GUIAbstractionNumber(Object component) {
            this.spinner = null;
            this.slider = null;
            if (component instanceof JSpinner && ((JSpinner)component).getModel() instanceof SpinnerNumberModel) {
                this.spinner = (JSpinner)component;
            } else if (component instanceof JSlider) {
                this.slider = (JSlider)component;
            } else {
                throw new IllegalArgumentException("GUIAbstractionNumber must be constructed with JSpinner (with SpinnerNumberModel) or JSlider, is " + component.getClass().getName());
            }
        }

        Object getValue() {
            if (this.spinner != null) {
                return this.spinner.getValue();
            }
            return this.slider.getValue();
        }

        void setValue(Object o) {
            if (this.spinner != null) {
                this.spinner.setValue(o);
            } else if (o instanceof Number) {
                this.slider.setValue(((Number)o).intValue());
            }
        }

        Class getNumberType() {
            return this.getValue().getClass();
        }
    }

    class GUIAbstractionText
    extends GUIAbstraction {
        private JTextField textfield;

        GUIAbstractionText(Object component) {
            if (component instanceof JTextField) {
                this.textfield = (JTextField)component;
            }
        }

        Object getValue() {
            return this.textfield.getText();
        }

        void setValue(Object o) {
            this.textfield.setText(o.toString());
        }
    }

    abstract class GUIAbstraction {
        GUIAbstraction() {
        }

        abstract Object getValue();

        abstract void setValue(Object var1);
    }
}

