/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.global;

import com.frinika.global.FrinikaConfig;
import com.frinika.gui.OptionsBinder;
import com.frinika.project.gui.ProjectFrame;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class ConfigDialog
extends JDialog {
    protected ProjectFrame parent;
    protected OptionsBinder optionsBinder;
    protected boolean hasBeenApplied = false;
    private JButton buttonApply;
    private JButton buttonCancel;
    private JButton buttonOk;
    private JPanel buttonPanel;
    private JPanel innerButtonPanel;

    public ConfigDialog(ProjectFrame parent, OptionsBinder optionsBinder) {
        super((Frame)parent, false);
        this.parent = parent;
        this.optionsBinder = optionsBinder;
        this.initComponents();
        this.getRootPane().setDefaultButton(this.buttonOk);
        this.setSize(750, 500);
        this.setLocation(300, 300);
    }

    public void show() {
        this.optionsBinder.refresh();
        super.show();
    }

    public void ok() {
        this.optionsBinder.update();
        this.parent.repaintViews();
        this.hasBeenApplied = false;
        this.hide();
        FrinikaConfig.store();
    }

    public void apply() {
        if (!this.hasBeenApplied) {
            this.optionsBinder.backup();
        }
        this.hasBeenApplied = true;
        this.optionsBinder.update();
        this.parent.repaintViews();
    }

    public void cancel() {
        if (this.hasBeenApplied) {
            this.optionsBinder.restore();
            this.hasBeenApplied = false;
            this.parent.repaintViews();
        }
        this.hide();
    }

    private void initComponents() {
        this.buttonPanel = new JPanel();
        this.innerButtonPanel = new JPanel();
        this.buttonOk = new JButton();
        this.buttonApply = new JButton();
        this.buttonCancel = new JButton();
        this.setDefaultCloseOperation(0);
        this.setTitle("Frinika Configuration");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ConfigDialog.this.formWindowClosing(evt);
            }
        });
        this.innerButtonPanel.setLayout(new GridLayout(1, 3, 5, 0));
        this.buttonOk.setText("OK");
        this.buttonOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConfigDialog.this.buttonOkActionPerformed(evt);
            }
        });
        this.innerButtonPanel.add(this.buttonOk);
        this.buttonApply.setText("Apply");
        this.buttonApply.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConfigDialog.this.buttonApplyActionPerformed(evt);
            }
        });
        this.innerButtonPanel.add(this.buttonApply);
        this.buttonCancel.setText("Cancel");
        this.buttonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConfigDialog.this.buttonCancelActionPerformed(evt);
            }
        });
        this.innerButtonPanel.add(this.buttonCancel);
        this.buttonPanel.add(this.innerButtonPanel);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.pack();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.cancel();
    }

    private void buttonOkActionPerformed(ActionEvent evt) {
        this.ok();
    }

    private void buttonApplyActionPerformed(ActionEvent evt) {
        this.apply();
    }

    private void buttonCancelActionPerformed(ActionEvent evt) {
        this.cancel();
    }
}

