/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.contrib.boblang;

import com.frinika.contrib.boblang.Fourier;
import com.frinika.contrib.boblang.Graph;
import java.awt.Color;

public class WaveSupport {
    public static final int PROP_COPY = 1;
    public static final int PROP_GLIDE = 2;
    public static final int PROP_ROTATE = 3;
    public static final double MAX_AMPLITUDE = 32000.0;
    public static final int MAX_GRAPH_HANDLE = 8;
    private static Graph[] graphList = new Graph[8];
    private static double[] sineTable = new double[360];
    private static double[] cosineTable = new double[360];

    public static int[] rescale(int[] waveform, double amplitude) {
        int numberOfSamples = waveform.length;
        int largestValue = 0;
        int smallestValue = 0;
        int greatestValue = 0;
        int[] scaledWave = new int[numberOfSamples];
        for (int i = 0; i < numberOfSamples; ++i) {
            int sample = waveform[i];
            if (sample > largestValue) {
                largestValue = sample;
            }
            if (sample < smallestValue) {
                smallestValue = sample;
            }
            greatestValue = largestValue;
            if (smallestValue >= 0 || -smallestValue <= largestValue) continue;
            greatestValue = -smallestValue;
        }
        double scaleFactor = amplitude / (double)greatestValue;
        for (int i = 0; i < numberOfSamples; ++i) {
            scaledWave[i] = (int)((double)waveform[i] * scaleFactor + 0.5);
        }
        return scaledWave;
    }

    public static int[] rescale(int[] waveform) {
        return WaveSupport.rescale(waveform, 32000.0);
    }

    public static int[] propagate(int[] halfWave, int desiredSize, int option) {
        int[] outArray = new int[desiredSize];
        int inLength = halfWave.length;
        int outPointer = 0;
        int inPointer = 0;
        System.arraycopy(halfWave, inPointer, outArray, outPointer, inLength);
        outPointer += inLength;
        switch (option) {
            case 1: {
                System.arraycopy(halfWave, inPointer, outArray, outPointer, inLength);
                outPointer += inLength;
                break;
            }
            case 2: {
                int i;
                for (i = 0; i < inLength; ++i) {
                    outArray[inLength + i] = -halfWave[i];
                }
                outPointer += inLength;
                break;
            }
            case 3: {
                int i;
                for (i = 0; i < inLength; ++i) {
                    outArray[inLength + i] = -halfWave[inLength - i - 1];
                }
                outPointer += inLength;
            }
        }
        while (outPointer <= desiredSize - inLength * 2) {
            System.arraycopy(outArray, inPointer, outArray, outPointer, inLength * 2);
            outPointer += inLength * 2;
        }
        int j = 0;
        for (int i = outPointer; i < desiredSize; ++i) {
            outArray[i] = outArray[j];
            ++j;
        }
        return outArray;
    }

    public static int[] filter(int[] halfWave, int filterWidth, int option) {
        int i;
        if (filterWidth < 1) {
            filterWidth = 1;
        }
        int inLength = halfWave.length;
        int workLength = inLength * 2 * 3;
        int resultLength = inLength * 2;
        int[] work = WaveSupport.propagate(halfWave, workLength, option);
        int[] result = new int[resultLength];
        int sum = 0;
        int firstIndex = inLength * 2 - filterWidth / 2;
        int lastIndex = firstIndex + filterWidth - 1;
        for (i = firstIndex; i <= lastIndex; ++i) {
            sum += work[i];
        }
        result[0] = sum / filterWidth;
        for (i = 1; i < resultLength; ++i) {
            sum -= work[firstIndex];
            ++firstIndex;
            result[i] = (sum += work[++lastIndex]) / filterWidth;
        }
        return result;
    }

    public static int[] increasingFilter(int[] halfWave, int filterWidth, int filterIncr, int desiredSize, int option) {
        int inLength = halfWave.length;
        int fullWaveLength = inLength * 2;
        int workLength = fullWaveLength * 3;
        int resultLength = desiredSize;
        int[] work = WaveSupport.propagate(halfWave, workLength, option);
        int[] result = new int[resultLength];
        int sum = 0;
        int firstIndex = fullWaveLength - filterWidth / 2;
        int lastIndex = firstIndex + filterWidth - 1;
        for (int i = firstIndex; i <= lastIndex; ++i) {
            sum += work[i];
        }
        result[0] = sum / filterWidth;
        int incrCount = 0;
        int workFilterWidth = filterWidth;
        for (int i = 1; i < resultLength; ++i) {
            if (++incrCount >= filterIncr) {
                incrCount = 0;
                ++workFilterWidth;
            } else {
                sum -= work[firstIndex];
                ++firstIndex;
            }
            result[i] = (sum += work[++lastIndex]) / workFilterWidth;
            if (firstIndex >= fullWaveLength) {
                firstIndex -= fullWaveLength;
            }
            if (lastIndex <= fullWaveLength) continue;
            lastIndex -= fullWaveLength;
        }
        return result;
    }

    public static int[] changeWaveLength(int[] inWave, int newWaveLength) {
        int inLength = inWave.length;
        int[] outWave = new int[newWaveLength];
        for (int i = 0; i < newWaveLength; ++i) {
            double scaledIndex = (double)i * (double)inLength / (double)newWaveLength;
            int baseIndex = (int)scaledIndex;
            double offset = scaledIndex - (double)baseIndex;
            int base = inWave[baseIndex];
            int step = inWave[(baseIndex + 1) % inLength] - base;
            outWave[i] = (int)((double)base + offset * (double)step);
        }
        return outWave;
    }

    public static synchronized void plotGraph(int handle, String inTitle, String inSubTitle, String inXTitle, String inYTitle, int[] inArray, int inElements) {
        int plotCount = inElements;
        if (plotCount > inArray.length) {
            plotCount = inArray.length;
        }
        if (handle < 8) {
            if (graphList[handle] != null) {
                graphList[handle].clearGraph(inTitle, inXTitle, inYTitle);
            } else {
                WaveSupport.graphList[handle] = new Graph(inTitle, inXTitle, inYTitle);
            }
            graphList[handle].setSubTitle(inSubTitle);
            graphList[handle].setColour(Graph.RED);
            for (int i = 0; i < plotCount; ++i) {
                graphList[handle].add(i, inArray[i]);
            }
            graphList[handle].showGraph(false);
        }
    }

    public static synchronized void plotGraph(int handle, String inTitle, String inSubTitle, String inXTitle, String inYTitle, int[] inArray, int inFirst, int inLast) {
        if (inLast > inArray.length) {
            inLast = inArray.length - 1;
        }
        if (inFirst > inLast) {
            inFirst = inLast - 24;
        }
        if (inFirst < 0) {
            inFirst = 0;
        }
        if (handle < 8) {
            if (graphList[handle] != null) {
                graphList[handle].clearGraph(inTitle, inXTitle, inYTitle);
            } else {
                WaveSupport.graphList[handle] = new Graph(inTitle, inXTitle, inYTitle);
            }
            graphList[handle].setSubTitle(inSubTitle);
            graphList[handle].setColour(Graph.RED);
            for (int i = inFirst; i < inLast; ++i) {
                graphList[handle].add(i - inFirst, inArray[i]);
            }
            graphList[handle].showGraph(false);
        }
    }

    public static synchronized void addGraph(int handle, Color inColour, int[] inArray, int inElements) {
        int plotCount = inElements;
        if (plotCount > inArray.length) {
            plotCount = inArray.length;
        }
        if (handle < 8) {
            if (graphList[handle] != null) {
                graphList[handle].nextGraph();
            } else {
                WaveSupport.graphList[handle] = new Graph("Untitled Graph", "x", "y");
            }
            graphList[handle].setColour(inColour);
            for (int i = 0; i < plotCount; ++i) {
                graphList[handle].add(i, inArray[i]);
            }
            graphList[handle].showGraph(false);
        }
    }

    public static synchronized void addGraph(int handle, Color inColour, int[] inArray, int inFirst, int inLast) {
        if (inLast > inArray.length) {
            inLast = inArray.length - 1;
        }
        if (inFirst > inLast) {
            inFirst = inLast - 24;
        }
        if (inFirst < 0) {
            inFirst = 0;
        }
        if (handle < 8) {
            if (graphList[handle] != null) {
                graphList[handle].nextGraph();
            } else {
                WaveSupport.graphList[handle] = new Graph("Untitled Graph", "x", "y");
            }
            graphList[handle].setColour(inColour);
            for (int i = inFirst; i < inLast; ++i) {
                graphList[handle].add(i - inFirst, inArray[i]);
            }
            graphList[handle].showGraph(false);
        }
    }

    public static synchronized void plotFourier(int handle, double[] inArray, int fourierSamples, int sampleRate, int inElements) {
        String graphTitle = "Fourier Transform";
        String subTitle = " ";
        String xTitle = "Hz";
        String yTitle = "Power";
        int plotCount = inElements;
        if (plotCount > inArray.length) {
            plotCount = inArray.length;
        }
        if (handle < 8) {
            if (graphList[handle] != null) {
                graphList[handle].clearGraph(graphTitle, xTitle, yTitle);
            } else {
                WaveSupport.graphList[handle] = new Graph(graphTitle, xTitle, yTitle);
            }
            graphList[handle].setSubTitle(subTitle);
            graphList[handle].setColour(Graph.BLUE);
            for (int i = 0; i < plotCount; ++i) {
                double freq = Fourier.frequencyFromBin(i, fourierSamples, sampleRate);
                graphList[handle].add(freq, inArray[i]);
            }
            graphList[handle].showGraph(false);
        }
    }

    public static final double localSine(double degrees) {
        int idegrees = (int)degrees + 360;
        return sineTable[idegrees %= 360];
    }

    public static final double localCosine(double degrees) {
        int idegrees = (int)degrees + 360;
        return cosineTable[idegrees %= 360];
    }

    static {
        for (int i = 0; i < 360; ++i) {
            WaveSupport.sineTable[i] = Math.sin(Math.PI * 2 * (double)i / 360.0);
            WaveSupport.cosineTable[i] = Math.sin(Math.PI * 2 * (double)i / 360.0);
        }
    }
}

