/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.contrib.boblang;

import com.frinika.contrib.boblang.CommandList;
import com.frinika.contrib.boblang.MidiInputBase;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Transmitter;
import javax.swing.JOptionPane;

public class PcMidiInputDriver
extends MidiInputBase
implements Receiver {
    public PcMidiInputDriver(CommandList inCommands, int midiInputDevice) {
        super(inCommands);
        try {
            MidiDevice.Info[] midiInfo = MidiSystem.getMidiDeviceInfo();
            MidiDevice dev = MidiSystem.getMidiDevice(midiInfo[midiInputDevice]);
            dev.open();
            Transmitter t = dev.getTransmitter();
            t.setReceiver(this);
        }
        catch (Exception e) {
            String m = "PcMidiInputDriver reports exception\n";
            m = m + e.toString();
            JOptionPane.showMessageDialog(null, m, null, 0);
            System.out.println("PcMidiInputDriver reports exception");
            System.out.println("Unable to open input midi device");
            System.out.println(e);
        }
    }

    public void close() {
        System.out.println("Receiver Close requested");
    }

    public void send(MidiMessage message, long timeStamp) {
        ShortMessage m = (ShortMessage)message;
        this.acceptCommand(m.getCommand(), m.getData1(), m.getData2());
    }
}

