/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.contrib.boblang;

import com.frinika.contrib.boblang.BezierParams;

public class BezierEnvelopeShaper {
    private static final int MAX_AMPLITUDE = 8000;
    private static final int MAX_PITCH = 128;
    private static final int HIGH_PITCH = 96;
    private static final int LOW_PITCH = 33;
    private static final int RELEASE_EXTRA = 48000;
    private int attackTime;
    private int decayTime;
    private int releaseTime;
    private int attackIndex;
    private int decayIndex;
    private double sustainLevel;
    private double attackLength;
    private double decayLength;
    private double releaseLength;

    public BezierEnvelopeShaper(BezierParams params) {
        this.reshapeEnvelope(params);
    }

    public final void reshapeEnvelope(BezierParams params) {
        this.attackTime = params.getEnvAttackTime();
        this.decayTime = params.getEnvDecayTime();
        this.releaseTime = params.getEnvReleaseTime();
        this.sustainLevel = (double)params.getEnvSusLevel() / 100.0;
        this.attackIndex = this.attackTime * params.getSampleRate() / 1000;
        this.decayIndex = (this.attackTime + this.decayTime) * params.getSampleRate() / 1000;
        this.attackLength = this.attackIndex;
        this.decayLength = this.decayIndex - this.attackIndex;
        this.releaseLength = (double)this.releaseTime * (double)params.getSampleRate() / 1000.0;
    }

    public final double getFactor(int index) {
        double factor;
        double dblIndex = index;
        if (index < this.attackIndex) {
            factor = dblIndex / this.attackLength;
            if (factor > 1.0) {
                factor = 1.0;
            }
        } else if (index < this.decayIndex) {
            double decayOffset = this.decayIndex - index;
            double attackOffset = index - this.attackIndex;
            factor = (decayOffset + this.sustainLevel * attackOffset) / this.decayLength;
        } else {
            factor = this.sustainLevel;
        }
        return factor;
    }

    public final double getRelFactor(int index, int releaseIndex) {
        double dblReleaseIndex = index - releaseIndex;
        double releaseFactor = this.sustainLevel * (1.0 - dblReleaseIndex / this.releaseLength);
        if (releaseFactor < 0.01) {
            releaseFactor = 0.0;
        }
        return releaseFactor;
    }

    public final boolean isNoteFinished(int index, int releaseIndex) {
        return this.getRelFactor(index, releaseIndex) < 0.01;
    }
}

