/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.chart;

import com.frinika.chart.Chart;
import com.frinika.chart.ChartPanel;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.filechooser.FileFilter;

public class ChartTest {
    private static FileFilter chartFileFilter = new ChartFileFilter();

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        Chart chart = new Chart();
        String keyRoot = "C";
        String scale = "Major";
        final ChartPanel chartPanel = new ChartPanel(chart);
        JMenuBar bar = new JMenuBar();
        frame.setJMenuBar(bar);
        bar.add(new JMenuItem(new AbstractAction("load"){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = new JFileChooser();
                fc.setFileFilter(chartFileFilter);
                int returnVal = fc.showOpenDialog(chartPanel);
                if (returnVal == 0) {
                    File file = fc.getSelectedFile();
                    try {
                        FileInputStream fin = new FileInputStream(file);
                        ObjectInputStream in = new ObjectInputStream(fin);
                        Object obj = in.readObject();
                        chartPanel.setChart((Chart)obj);
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    catch (ClassNotFoundException e2) {
                        e2.printStackTrace();
                    }
                }
            }
        }));
        bar.add(new JMenuItem(new AbstractAction("save"){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = new JFileChooser();
                fc.setFileFilter(chartFileFilter);
                int returnVal = fc.showOpenDialog(chartPanel);
                if (returnVal == 0) {
                    File file = fc.getSelectedFile();
                    try {
                        FileOutputStream fout = new FileOutputStream(file);
                        ObjectOutputStream out = new ObjectOutputStream(fout);
                        out.writeObject(chartPanel.getChart());
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }));
        frame.setContentPane(chartPanel);
        chart.setDefaultKey(keyRoot, scale);
        chart.appendBar("C", 4);
        chart.appendBar("Gm7", 4);
        chart.appendBar("A#+5", 4);
        chart.appendBar("D / Cm /", 4);
        chart.appendBar("A / / F", 4);
        chart.appendBar("Dbmaj7(b5) / / /", 4);
        frame.setSize(500, 800);
        frame.setVisible(true);
        frame.repaint();
    }

    private static class ChartFileFilter
    extends FileFilter {
        private ChartFileFilter() {
        }

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            if (!f.isFile()) {
                return false;
            }
            return f.getName().toLowerCase().endsWith(".chart");
        }

        public String getDescription() {
            return "Chart Files (*.chart)";
        }
    }
}

