/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.chart;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Observable;
import java.util.StringTokenizer;
import java.util.Vector;
import uk.org.toot.music.tonality.Chords;
import uk.org.toot.music.tonality.Key;
import uk.org.toot.music.tonality.Pitch;
import uk.org.toot.music.tonality.Scale;
import uk.org.toot.music.tonality.Scales;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Chart
extends Observable
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Vector<Bar> bars = new Vector();
    private int beatsPerBar = 4;
    private String keyRoot;
    private String scale;

    public void appendBar() {
        this.bars.add(new Bar(this.beatsPerBar));
    }

    public void appendBar(String string, int beats) {
        Bar bar = new Bar(beats);
        this.bars.add(bar);
        bar.set(string, this.keyRoot, this.scale);
        this.setChanged();
    }

    public void appendBar(String string, String keyRoot, String scale, int beats) {
        Bar bar = new Bar(beats);
        this.bars.add(bar);
        bar.set(string, keyRoot, scale);
        this.setChanged();
    }

    public List<Bar> getBars() {
        return this.bars;
    }

    public void setbarAt(int index, String string) {
        this.bars.get(index).set(string, this.keyRoot, this.scale);
        this.setChanged();
        this.notifyObservers();
    }

    public void setbarAt(int index, String string, String keyRoot, String scale) {
        this.bars.get(index).set(string, keyRoot, scale);
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        for (Bar bar : this.bars) {
            buff.append(bar.toString());
            buff.append("|");
        }
        return buff.toString();
    }

    public void setDefaultKey(String keyRoot, String scale) {
        this.keyRoot = keyRoot;
        this.scale = scale;
    }

    public class Chord
    implements Serializable {
        String name;
        private static final long serialVersionUID = 1L;
        transient uk.org.toot.music.tonality.Chord chord;
        transient int root;
        transient Key key;
        int beats;
        String scaleName;
        String scaleRoot;
        int[] chordInt;

        private Chord(Chord cloneMe) {
            this.name = cloneMe.name;
            this.root = cloneMe.root;
            this.beats = cloneMe.beats;
            this.chord = cloneMe.chord;
            this.chordInt = cloneMe.chordInt;
            this.scaleName = cloneMe.scaleName;
            this.scaleRoot = cloneMe.scaleRoot;
            this.key = cloneMe.key;
        }

        private Chord(String name, String keyRoot, String scaleName) {
            this.name = name;
            this.scaleName = scaleName;
            Scale scale = Scales.getScale((String)scaleName);
            int kr = Pitch.classValue((String)keyRoot);
            this.key = new Key(kr, scale);
            this.buildFromName();
        }

        private void buildFromName() {
            char c;
            this.root = Pitch.classValue((String)this.name);
            String string = this.name;
            string = string.length() > 1 ? ((c = string.charAt(1)) == 'b' || c == '#' ? string.substring(2, string.length()) : string.substring(1, string.length())) : string.substring(1, string.length());
            this.chord = Chords.withSymbol((String)string);
            assert (this.chord != null);
            this.chordInt = this.chord.getIntervals();
            assert (this.chordInt != null);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.buildFromName();
        }

        private void setDuration(int beats) {
            this.beats = beats;
        }

        public int getDuration() {
            return this.beats;
        }

        public int getRoot() {
            return this.root;
        }

        public String toString() {
            return this.name;
        }

        public int getChordNoteAt(int i) {
            return this.root + this.chord.getIntervals()[i % this.chordInt.length];
        }

        public Key getKey() {
            return this.key;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Bar
    implements Serializable {
        private static final long serialVersionUID = 1L;
        Vector<Chord> chords = new Vector();
        int beats;

        private Bar(int beats) {
            this.beats = beats;
        }

        private void addChord(String string, String keyRoot, String scaleName) {
            if (!(string = string.trim()).equals("/")) {
                this.chords.add(new Chord(string, keyRoot, scaleName));
            } else {
                this.chords.add(new Chord(this.chords.lastElement()));
            }
        }

        public int getBeats() {
            return this.beats;
        }

        public List<Chord> getChords() {
            return this.chords;
        }

        private void spaceChords() {
            int n = this.chords.size();
            if (n == 1) {
                this.chords.get(0).setDuration(this.beats);
            } else if (n == this.beats) {
                for (Chord chord : this.chords) {
                    chord.setDuration(1);
                }
            } else {
                int inc = this.beats / this.chords.size();
                int bb = 0;
                for (Chord chord : this.chords) {
                    chord.setDuration(bb + inc);
                }
                try {
                    throw new Exception(" chords do not fit the bar");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        public String toString() {
            StringBuffer str = new StringBuffer();
            for (Chord chord : this.chords) {
                str.append(chord.toString() + " ");
            }
            return str.toString();
        }

        private void set(String string, String keyRoot, String scale) {
            this.chords.clear();
            StringTokenizer toker = new StringTokenizer(string);
            while (toker.hasMoreTokens()) {
                this.addChord(toker.nextToken(), keyRoot, scale);
            }
            this.spaceChords();
            Chart.this.setChanged();
        }
    }
}

