/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.benchmark.audio;

import com.frinika.audio.VoiceServer;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PJVoiceServer
extends VoiceServer
implements Runnable {
    Mixer.Info currentMixer;
    AudioFormat format = new AudioFormat(this.getSampleRate(), 16, 2, true, true);
    DataLine.Info infoOut = new DataLine.Info(SourceDataLine.class, this.format);
    SourceDataLine lineOut;
    boolean isRunning = false;
    boolean hasStopped = false;
    int bufferSize = 2048;
    protected boolean ultraLowLatency = false;
    protected boolean standardLatency = false;
    private boolean useEstimatedFramePos = true;

    public PJVoiceServer(int bufferSize) {
        if (System.getProperty("os.name").equals("Mac OS X")) {
            System.out.println("Detected Mac OS X. Automatically tuning audio device settings. ");
            this.useEstimatedFramePos = false;
            this.ultraLowLatency = true;
        }
        this.currentMixer = AudioSystem.getMixerInfo()[0];
        this.bufferSize = 4 * bufferSize;
        this.startAudioOutput();
    }

    public void startAudioOutput() {
        try {
            this.lineOut = (SourceDataLine)AudioSystem.getMixer(this.currentMixer).getLine(this.infoOut);
            if (this.standardLatency) {
                this.lineOut.open(this.format, this.bufferSize);
            } else {
                this.lineOut.open(this.format);
            }
            this.lineOut.start();
            System.out.println("Buffersize: " + this.bufferSize + " / " + this.lineOut.getBufferSize());
        }
        catch (Exception e) {
            this.lineOut = null;
            System.out.println("No audio output available. Use Audio Devices dialog to reconfigure.");
        }
        Thread thread = new Thread(this);
        thread.start();
    }

    public void stopAudioOutput() throws Exception {
        this.isRunning = false;
        while (!this.hasStopped) {
            Thread.yield();
        }
        this.hasStopped = false;
        if (this.lineOut != null) {
            this.lineOut.drain();
            this.lineOut.stop();
            this.lineOut.close();
        }
    }

    public void run() {
        try {
            this.isRunning = true;
            byte[] outBuffer = new byte[this.bufferSize];
            float[] floatBuffer = new float[this.bufferSize / 2];
            long totalTimeNanos = (long)((float)this.bufferSize / 4.0f / (float)this.getSampleRate() * 1.0E9f);
            long expireNanos = 0L;
            long framesWritten = 0L;
            while (this.isRunning) {
                long startTimeNanos = System.nanoTime();
                for (int n = 0; n < floatBuffer.length; ++n) {
                    floatBuffer[n] = 0.0f;
                }
                this.read(outBuffer, floatBuffer);
                long endTimeNanos = System.nanoTime();
                if (this.lineOut != null) {
                    System.out.println(this.lineOut.getBufferSize() - this.lineOut.available());
                    this.lineOut.write(outBuffer, 0, outBuffer.length);
                }
                if (!this.standardLatency) {
                    expireNanos = expireNanos < System.nanoTime() ? System.nanoTime() + totalTimeNanos : (expireNanos += totalTimeNanos);
                    if (this.ultraLowLatency) {
                        if (this.useEstimatedFramePos) {
                            while (expireNanos - System.nanoTime() > totalTimeNanos) {
                                Thread.yield();
                            }
                        } else {
                            while (this.lineOut.getLongFramePosition() < framesWritten) {
                                Thread.yield();
                            }
                        }
                    } else {
                        long sleepNanos = expireNanos - totalTimeNanos - System.nanoTime();
                        if (sleepNanos > 0L) {
                            Thread.sleep(sleepNanos / 1000000L, (int)(sleepNanos % 1000000L));
                        }
                    }
                }
                framesWritten += (long)(outBuffer.length / 4);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.hasStopped = true;
    }

    public void configureAudioOutput(JFrame frame) {
        JDialog dialog = new JDialog((Frame)frame, "Audio devices");
        dialog.setLayout(new GridLayout(8, 1));
        Vector<Mixer.Info> mixers = new Vector<Mixer.Info>();
        for (Mixer.Info mInfo : AudioSystem.getMixerInfo()) {
            System.out.println(mInfo);
            if (!AudioSystem.getMixer(mInfo).isLineSupported(this.infoOut)) continue;
            mixers.add(mInfo);
        }
        final JComboBox cb = new JComboBox(mixers);
        dialog.add(cb);
        dialog.add(new JLabel("Slide to adjust latency:"));
        final JSlider sl = new JSlider(64, 8192);
        sl.setToolTipText("Slide to adjust latency");
        dialog.add(sl);
        final JLabel lb = new JLabel();
        dialog.add(lb);
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class LatencyListener
        implements ChangeListener {
            int bufferSize = 0;

            LatencyListener() {
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                this.bufferSize = sl.getValue() / 64 * 64;
                lb.setText("Latency = " + this.bufferSize + " frames");
            }
        }
        final LatencyListener latencyListener = new LatencyListener();
        sl.addChangeListener(latencyListener);
        sl.setValue(this.bufferSize / 4);
        final JCheckBox ultraLowLatencyCheckBox = new JCheckBox("Ultra-low latency support (CAREFUL - eats all CPU it can get)", this.ultraLowLatency);
        final JCheckBox useEstimatedFramePosCheckBox = new JCheckBox("Use Frinika estimated framepos", this.useEstimatedFramePos);
        ultraLowLatencyCheckBox.setToolTipText("If you set a low latency (typical below 1024) above, you might need to turn this on as well. ");
        ultraLowLatencyCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                PJVoiceServer.this.ultraLowLatency = ultraLowLatencyCheckBox.isSelected();
                useEstimatedFramePosCheckBox.setEnabled(!PJVoiceServer.this.standardLatency & PJVoiceServer.this.ultraLowLatency);
            }
        });
        ultraLowLatencyCheckBox.setEnabled(!this.standardLatency);
        dialog.add(ultraLowLatencyCheckBox);
        useEstimatedFramePosCheckBox.setToolTipText("On some systems Frinika does a better estimation of the audio position, on others not... ");
        useEstimatedFramePosCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                PJVoiceServer.this.useEstimatedFramePos = useEstimatedFramePosCheckBox.isSelected();
            }
        });
        useEstimatedFramePosCheckBox.setEnabled(!this.standardLatency & this.ultraLowLatency);
        dialog.add(useEstimatedFramePosCheckBox);
        final JCheckBox standardLatencyCheckBox = new JCheckBox("Use standard javasound latency control", this.standardLatency);
        standardLatencyCheckBox.setToolTipText("This is the standard javasound method for latency control, may be good on some systems - but not on others.. ");
        standardLatencyCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                PJVoiceServer.this.standardLatency = standardLatencyCheckBox.isSelected();
                useEstimatedFramePosCheckBox.setEnabled(!PJVoiceServer.this.standardLatency & PJVoiceServer.this.ultraLowLatency);
                ultraLowLatencyCheckBox.setEnabled(!PJVoiceServer.this.standardLatency);
            }
        });
        dialog.add(standardLatencyCheckBox);
        JButton applyButton = new JButton("Apply");
        applyButton.addActionListener(new ActionListener(){
            {
            }

            public void actionPerformed(ActionEvent e) {
                try {
                    PJVoiceServer.this.stopAudioOutput();
                    PJVoiceServer.this.bufferSize = latencyListener.bufferSize * 4;
                    PJVoiceServer.this.currentMixer = (Mixer.Info)cb.getSelectedItem();
                    PJVoiceServer.this.startAudioOutput();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        dialog.add(applyButton);
        dialog.setSize(600, 200);
        dialog.setVisible(true);
    }

    public void setBufferSize(int len) throws Exception {
        this.stopAudioOutput();
        this.bufferSize = len * 4;
        this.startAudioOutput();
    }

    public void printStats() {
    }
}

