/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.benchmark.audio;

import com.frinika.benchmark.SyncVoice;
import com.frinika.benchmark.audio.ClickOscillator;
import com.frinika.global.FrinikaConfig;
import com.frinika.sequencer.FrinikaSequencer;
import com.frinika.sequencer.gui.AudioDeviceHandle;
import javax.sound.sampled.TargetDataLine;

public class ClickListener
extends SyncVoice {
    TargetDataLine lineIn = null;
    byte[] inBuffer;
    FrinikaSequencer sequencer;
    static int OFF = 0;
    static int ARMED = 1;
    static int RECORDING = 2;
    AudioDeviceHandle audioDeviceHandle;
    int state = OFF;
    int nChannel = 0;
    long framePtrLast = 0L;
    float thresh;
    boolean monit;
    private ClickOscillator out;

    public ClickListener(FrinikaSequencer seq, boolean monit, ClickOscillator out, float thresh) {
        super(seq);
        this.monit = monit;
        this.out = out;
        this.thresh = thresh;
    }

    public void setAudioDeviceHandle(AudioDeviceHandle audio) {
        this.audioDeviceHandle = audio;
        this.nChannel = this.audioDeviceHandle.getChannels();
        System.out.println(this.audioDeviceHandle.toString() + "   " + this.nChannel);
    }

    public void fillBuffer(int startBufferPos, int endBufferPos, float[] buffer) {
        try {
            if (this.lineIn == null) {
                this.lineIn = this.audioDeviceHandle.getOpenLine();
                this.lineIn.start();
            }
            if (this.inBuffer == null || this.inBuffer.length != buffer.length * this.nChannel) {
                this.inBuffer = new byte[buffer.length * this.nChannel];
            }
            if (this.glitched) {
                this.doSync(0);
            }
            int nByte = this.nChannel * (endBufferPos - startBufferPos);
            if (this.lineIn.available() >= nByte) {
                int cnt = 0;
                do {
                    int nread = this.lineIn.read(this.inBuffer, 0, nByte);
                    ++cnt;
                } while (this.lineIn.available() > 2 * nByte);
                if (cnt != 1) {
                    System.err.println(" LineIn OVER RUN ");
                    this.glitched = true;
                }
                for (int n = 0; n < nByte / 2; ++n) {
                    short sample = (short)((0xFF & this.inBuffer[2 * n + 1]) + (0xFF & this.inBuffer[2 * n]) * 256);
                    float val = (float)sample / 32768.0f;
                    if (n % this.nChannel == 0) {
                        ++this.framePtr;
                    }
                    if (val > this.thresh) {
                        long nF = this.framePtr - this.out.clickFrame;
                        double t = nF / (long)FrinikaConfig.sampleRate;
                        System.out.println(" latency in frames " + nF + " [ " + t + " secs]");
                    }
                    if (!this.monit) continue;
                    if (this.nChannel == 1) {
                        int n2 = startBufferPos + 2 * n;
                        buffer[n2] = buffer[n2] + val;
                        int n3 = startBufferPos + 2 * n + 1;
                        buffer[n3] = buffer[n3] + val;
                        continue;
                    }
                    int n4 = startBufferPos + n;
                    buffer[n4] = buffer[n4] + val;
                }
            } else {
                System.err.println(" LineIn UNDER RUN ");
                this.glitched = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.framePtrLast = this.framePtr;
    }

    protected void correctGlitch() {
    }
}

