/*
 * Decompiled with CFR 0.152.
 */
package com.frinika;

import com.frinika.About;
import com.frinika.SplashDialog;
import com.frinika.WelcomeDialog;
import com.frinika.audio.toot.FrinikaAudioSystem;
import com.frinika.global.FrinikaConfig;
import com.frinika.global.Toolbox;
import com.frinika.localization.CurrentLocale;
import com.frinika.midi.MidiInDeviceManager;
import com.frinika.project.ProjectContainer;
import com.frinika.project.gui.ProjectFocusListener;
import com.frinika.project.gui.ProjectFrame;
import com.frinika.sequencer.gui.menu.CreateProjectAction;
import com.frinika.sequencer.gui.menu.OpenProjectAction;
import com.frinika.settings.SetupDialog;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticXPLookAndFeel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import net.roydesign.app.Application;

public class FrinikaMain {
    static FrinikaExitHandler exitHook = null;
    private static boolean ismac = false;

    public static void main(String[] args) throws Exception {
        FrinikaMain.prepareRunningFromSingleJar();
        FrinikaMain.configureUI();
        try {
            int n = 1;
            Object[] options = new Object[]{CurrentLocale.getMessage("welcome.new_project"), CurrentLocale.getMessage("welcome.open_existing"), CurrentLocale.getMessage("welcome.settings"), CurrentLocale.getMessage("welcome.quit")};
            WelcomeDialog welcome = new WelcomeDialog(options);
            if (!FrinikaConfig.SETUP_DONE) {
                welcome.setModal(false);
                welcome.setVisible(true);
                SetupDialog.showSettingsModal();
                welcome.setVisible(false);
            }
            welcome.setModal(true);
            welcome.addButtonActionListener(2, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SetupDialog.showSettingsModal();
                }
            });
            welcome.setVisible(true);
            n = welcome.getSelectedOption();
            switch (n) {
                case -1: {
                    System.exit(0);
                    break;
                }
                case 0: {
                    SplashDialog.showSplash();
                    new CreateProjectAction().actionPerformed(null);
                    break;
                }
                case 1: {
                    SplashDialog.showSplash();
                    String lastFile = FrinikaConfig.lastProjectFile();
                    if (lastFile != null) {
                        OpenProjectAction.setSelectedFile(new File(lastFile));
                    }
                    new OpenProjectAction().actionPerformed(null);
                    break;
                }
                case 3: {
                    System.exit(0);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
        exitHook = new FrinikaExitHandler();
        Runtime.getRuntime().addShutdownHook(exitHook);
        ProjectFrame.addProjectFocusListener(new ProjectFocusListener(){

            public void projectFocusNotify(ProjectContainer project) {
                FrinikaAudioSystem.installClient(project.getAudioClient());
            }
        });
        SplashDialog.closeSplash();
        FrinikaAudioSystem.getAudioServer().start();
    }

    public static boolean isMac() {
        return ismac;
    }

    private static void configureUI_MacOS() {
        try {
            ismac = true;
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "Frinika");
            Object cMenuBarUI = UIManager.get("MenuBarUI");
            Object cMenuItemUI = UIManager.get("MenuItemUI");
            Object cMenuUI = UIManager.get("MenuUI");
            Object cCheckBoxMenuItemUI = UIManager.get("CheckBoxMenuItemUI");
            Object cRadioButtonMenuItemUI = UIManager.get("RadioButtonMenuItemUI");
            Object cPopupMenuUI = UIManager.get("PopupMenuUI");
            Object cProgressBarUI = UIManager.get("ProgressBarUI");
            UIManager.setLookAndFeel((LookAndFeel)new PlasticLookAndFeel());
            UIManager.put("MenuBarUI", cMenuBarUI);
            UIManager.put("MenuItemUI", cMenuItemUI);
            UIManager.put("MenuUI", cMenuUI);
            UIManager.put("CheckBoxMenuItemUI", cCheckBoxMenuItemUI);
            UIManager.put("RadioButtonMenuItemUI", cRadioButtonMenuItemUI);
            UIManager.put("PopupMenuUI", cPopupMenuUI);
            UIManager.put("ProgressBarUI", cProgressBarUI);
            Application.getInstance().getAboutJMenuItem().addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    About.about(null);
                }
            });
            Application.getInstance().getQuitJMenuItem().addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    ProjectFrame.getFocusFrame().tryQuit();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void configureUI() {
        String lcOSName = System.getProperty("os.name").toLowerCase();
        boolean MAC_OS_X = lcOSName.startsWith("mac os x");
        if (MAC_OS_X) {
            FrinikaMain.configureUI_MacOS();
            return;
        }
        try {
            UIManager.setLookAndFeel((LookAndFeel)new PlasticXPLookAndFeel());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void prepareRunningFromSingleJar() {
        File file;
        String classpath = System.getProperty("java.class.path");
        if (classpath.indexOf(File.pathSeparator) == -1 && classpath.endsWith(".jar") && (file = new File(classpath)).exists() && file.isFile()) {
            String osarch = System.getProperty("os.arch");
            String osname = System.getProperty("os.name");
            String libPrefix = "lib/" + osarch + "/" + osname + "/";
            String tmp = System.getProperty("java.io.tmpdir");
            File tmpdir = new File(tmp);
            try {
                System.out.println("extracting files from " + libPrefix + " to " + tmpdir.getAbsolutePath() + ":");
                Toolbox.extractFromJar(file, libPrefix, tmpdir);
                System.setProperty("java.library.path", tmp);
            }
            catch (IOException ioe) {
                System.err.println("Native library extraction failed. Problems may occur.");
                ioe.printStackTrace();
            }
        }
    }

    static class FrinikaExitHandler
    extends Thread {
        FrinikaExitHandler() {
        }

        public void run() {
            MidiInDeviceManager.close();
            FrinikaAudioSystem.close();
        }
    }
}

