//
// WAV -> RAW converter for ReBoy
// v0.0
//
// (w)2009 by lsl/checkpoint
// http://checkpoint.atari.org
//

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <direct.h>
#include <io.h>


#include "_conio.h"
#include "datatypes.h"
#include "filestuff.h"
#include "readdir.h"

#include "wav_struct.h"
#include "wav.h"


char start_directory[512];
char samplename[512]="hightom.WAV";


char samples_directory[512]="samples";

char reboy_template_fname[]="ReBoy.template.bin";	// template filename
int reboy_template_size;
u8 *reboy_template;

char reboy_out_fname[]="ReBoy.bin";					// output filename
FILE *reboy_out_file;


u32 samples_text_start;
u32 samples_list_start;
u32 samples_raw_start;

#define NULL_BUFFER_SIZE 4096
u8 null_buffer[NULL_BUFFER_SIZE];


u32 readID(u8 *ptr)
{
	return (ptr[0]<<24)|(ptr[1]<<16)|(ptr[2]<<8)|ptr[3];
}

u32 read32(u8 *ptr)
{
	return (ptr[3]<<24)|(ptr[2]<<16)|(ptr[1]<<8)|ptr[0];
}

s32 read16(s8 *ptr)
{
	s32 value = (ptr[1]*256);
	value = value | ((u8)ptr[0]);
	return value;
}

void write32(u8 *ptr,u32 value)
{
	ptr[0] = value;
	ptr[1] = value>>8;
	ptr[2] = value>>16;
	ptr[3] = value>>24;
}


u8 *WAVsrc;

int WAVsize, RIFFsize;

int file_format_tag;
int file_channels;
int file_sample_rate;
int file_bytes_second;
int file_block_align;
int file_bits_sample;
int file_data_length;

int num_samples;

u32 ID;


int read_WAV_header()
{
	int i;

	// check 'RIFF'
	ID = readID(WAVsrc + RIFF_start);
	printf("\nstartID: 0x%X",ID);
	if(ID != 'RIFF')
	{
		printf("\n\nERROR: no 'RIFF' header!");
		return -1;
	}

	RIFFsize = read32(WAVsrc + filesize);
	printf("\nRIFFsize: %i",RIFFsize);

	// check 'WAVE'
	ID = readID(WAVsrc + WAVE_start);
	printf("\n0x%X",ID);
	if(ID != 'WAVE')
	{
		printf("\n\nERROR: no 'WAVE' header!");
		return -1;		
	}

	// check fmt_start
	ID = readID(WAVsrc + fmt_start);
	printf("\n0x%X",ID);
	if(ID != 'fmt ')
	{
		printf("\n\nERROR: no 'fmt ' header!");
		return -1;		
	}

	// fmt_length
	i = read32(WAVsrc + fmt_length);
	printf("\nfmt_length: %i",i);
	if(i!=16)
	{
		printf("\n\nERROR: fmt_length != 16 !");
		return -1;
	}

	// format tag
	file_format_tag	= read16(WAVsrc + format_tag);
	printf("\nformat_tag: %X",file_format_tag);
	if(file_format_tag != 0x0001)
	{
		printf("\n\nERROR: only PCM supported !");
		return -1;
	}

	// channels
	file_channels = read16(WAVsrc + channels);
	printf("\nchannels: %i",file_channels);
	if(file_channels > 2)
	{
		printf("\n\nERROR: only 1 or 2 channels supported !");
		return -1;
	}

	// sample rate
	file_sample_rate = read32(WAVsrc + sample_rate);
	printf("\nsamplerate:   %i Hz",file_sample_rate);

	// bytes_second
	file_bytes_second = read32(WAVsrc + bytes_second);
	printf("\nbytes_second: %i",file_bytes_second);

	// block_align
	file_block_align = read16(WAVsrc + block_align);
	printf("\nblock_align:  %i",file_block_align);

	// bits_sample
	file_bits_sample = read16(WAVsrc + bits_sample);
	printf("\nbits_sample:  %i",file_bits_sample);
	if( (file_bits_sample!=8)&&(file_bits_sample!=16))
	{
		printf("\n\nERROR: only 8 or 16 bits per sample !");
		return -1;
	}

	// check 'data'
	ID = readID(WAVsrc + data_start);
	printf("\n0x%X",ID);
	if(ID != 'data')
	{
		printf("\n\nERROR: no 'data' header!");
		waitkey();
		return -1;		
	}

	// data_length
	file_data_length = read32(WAVsrc + data_length);
	printf("\ndata_length:  %i",file_data_length);

	num_samples = file_data_length / file_channels;
	switch (file_bits_sample)
	{
		case 8:
			break;
		case 16:
			num_samples = num_samples/2;
			break;
		default:
			break;
	}

	printf("\nnum_samples:  %i",num_samples);

	if(num_samples > 4194303)
	{
		printf("\n\nERROR: sample too big !");
		printf("\nmax. samplesize is 4194303 --> app. 3:29 minutes");
		waitkey();
		return -1;
	}
 
	return 0;
}



s8 *RAWout;
s8 *ptr;

s32 read_sample()
{
	s32 spl;
	switch (file_bits_sample)
	{
		case 8:
			spl = *ptr++;
			break;
		case 16:
			spl = read16(ptr);
			ptr+=2;
			break;
		default:
			break;
	}
	return spl;
}

int convert_WAV_to_8bitSignedMonoRAW()
{
	int i;
	s32 spl0,spl1;
	FILE *dump;

	ptr = WAVsrc + SAMPLE_DATA;

	RAWout = malloc(num_samples+1024);


	for(i=0;i<num_samples;i++)
	{
		switch (file_channels)
		{
			case 1:						// 1 channel
				spl0 = read_sample();
				break;
			case 2:						// 2 channels
				spl0 = read_sample();
				spl1 = read_sample();
				spl0 = (spl0+spl1)/2;	// mix channels
				break;
			default:
				break;
		}
		switch (file_bits_sample)
		{
			case 8:						// 8 bit input is always unsigned
				spl0 = spl0-128;		// convert to signed
				break;
			case 16:
				spl0 = spl0>>8;
				break;
			default:
				break;
		}
		RAWout[i] = spl0;				// 8 bit, signed, mono output

		//printf("%i ",spl0);
	
	}

	// write raw 8 bit sample data to output file
	fwrite(RAWout, num_samples, 1, reboy_out_file);
	fwrite(null_buffer,   1024, 1, reboy_out_file);

	/*
	dump = fopen("output.spl","wb");
	fwrite(RAWout, num_samples, 1,dump);
	fclose(dump);
	*/

	free(RAWout);

	return 0;
}



int load_WAV(char *WAVfname)
{
	WAVsize = get_filesize(WAVfname);
	if ( WAVsize == -1)
	{
		printf("\n\n*** ERROR opening >%s< ***",WAVfname);
		waitkey();
		return -1;
	}

	WAVsrc = malloc(WAVsize);

	load_file(WAVfname,WAVsrc);


	printf("\n%s",WAVfname);
	printf("\n%i bytes",WAVsize);

	if (read_WAV_header())
	{
		free(WAVsrc);
		return -1;
	}

	convert_WAV_to_8bitSignedMonoRAW();
	free(WAVsrc);
	return 0;
}


int load_WAV_header(char *WAVfname)
{
	FILE *file;

	WAVsize = get_filesize(WAVfname);
	if ( WAVsize == -1)
	{
		printf("\n\nERROR opening >%s<",WAVfname);
		return -1;
	}

	WAVsrc = malloc(SAMPLE_DATA+16);

	file=fopen(WAVfname,"rb");
	if(file)
	{
		fread(WAVsrc, SAMPLE_DATA, 1, file);
		fclose(file);
	}
	else
	{
		free(WAVsrc);
		return -1;
	}


	printf("\n\n%s",WAVfname);
	printf("\n%i bytes",WAVsize);

	if (read_WAV_header())
	{
		free(WAVsrc);
		return -1;
	}

	free(WAVsrc);
	return 0;
}


//-------------------------------------------------------------------------------------------------
int main(int argc,char **argv)
{

	int i,j,header_start;
	char cwd_buff[512];

	u8 *ptr;

	char header[]="ReBoy";

	printf("\nReBoy sample includer");
	printf("\n---------------------\n\n");

	getcwd(start_directory,512);

	for(i=0;i<NULL_BUFFER_SIZE;i++) null_buffer[i] = 0x00;

	reboy_template_size = get_filesize(reboy_template_fname);
	if(reboy_template_size == -1)
	{
		printf("\n*** ERRROR OPENING: %s",reboy_template_fname);
		waitkey();
		return -1;
	}

	reboy_template = (u8*)malloc(reboy_template_size+1024);

	load_file(reboy_template_fname, reboy_template);

	j = 0;
	for(i=0;i<512;i++)
	{
		if(header[j] == reboy_template[i])
		{
			if(j==0) header_start = i;
			j++;
			if(header[j] == 0x00)
			{
				break;
			}
		}
		else
		{
			j = 0;
		}
	}
	if(i==512)
	{
		printf("\n\n *** ERROR: can't locate ReBoy header ***");
		waitkey();
		free(reboy_template);
		return -1;
	}

	ptr = reboy_template + header_start;

	// get offsets
	samples_text_start = read32(ptr+16);
	samples_list_start = read32(ptr+24);
	samples_raw_start  = read32(ptr+32);
	
	printf("\nsamples_text_start: %X",samples_text_start);
	printf("\nsamples_list_start: %X",samples_list_start);
	printf("\nsamples_raw_start:  %X",samples_raw_start );


	// open output file
	reboy_out_file = fopen(reboy_out_fname,"wb");


	if ( chdir(samples_directory) )
	{
		printf("\n\n***ERROR OPENING SAMPLE-DIRECTORY >%s< ***",samples_directory);
		waitkey();
		free(reboy_template);
		fclose(reboy_out_file);
		return -1;
	}


	getcwd(cwd_buff,512);
	printf("\n\n%s\n\n",cwd_buff);

	if (read_directory()==-1)
	{
		printf("\n\n*** ERROR: NO SAMPLES FOUND ***");
		waitkey();
		free(reboy_template);
		fclose(reboy_out_file);
		return -1;
	}

	printf("\n\n\nALL SAMPLES SUCCESSFUL ADDED!\n");
	printf("Use %s on your GBA or emulator now!\n",reboy_out_fname);
	printf("                                       press a key...\n\n");

	waitkey();

	free(reboy_template);
	fclose(reboy_out_file);
	return 0;
}