DECLARE SUB PlayMod (position%, row%)
DECLARE SUB StopMod ()
DECLARE SUB settimerfrq (hz%)
DECLARE SUB loadmod (filenm$)
DECLARE SUB eraseins (ini%)
DECLARE FUNCTION readb% (fh%)
DECLARE SUB opl.setinstr (v%, i AS ANY)
DECLARE SUB opl.out (reg%, vlu%)
DECLARE SUB RemovePlayer ()
DECLARE SUB ems.freepages (handle%)
DECLARE SUB ems.mappage (phy%, lgc%, handle%)
DECLARE FUNCTION InstallPlayer% ()
DECLARE FUNCTION ems.pageframe% ()
DECLARE FUNCTION ems.allocpages% (npages%)
DECLARE SUB eraseptn (ptn%)
DEFINT A-Z
'$INCLUDE: 'QB.BI'
TYPE Instrument
	mul1 AS INTEGER
	mul2 AS INTEGER
	lev1 AS INTEGER
	lev2 AS INTEGER
	atd1 AS INTEGER
	atd2 AS INTEGER
	sur1 AS INTEGER
	sur2 AS INTEGER
	wav1 AS INTEGER
	wav2 AS INTEGER
	fbcon AS INTEGER
END TYPE
DIM SHARED modptr(0 TO 8) AS LONG
DIM SHARED regs AS RegType
DIM SHARED ems.status, emsh, emsseg
DIM SHARED VocOff(0 TO 8)
DIM SHARED frqtab(0 TO 11)
DIM SHARED ins(0 TO 32) AS Instrument
DIM SHARED length
DIM SHARED ord(0 TO 8, 0 TO 255)
DIM SHARED nbuf(0 TO 63, 0 TO 8)
DIM SHARED obuf(0 TO 63, 0 TO 8)
DIM SHARED ibuf(0 TO 63, 0 TO 8)
DIM SHARED ehbuf(0 TO 63, 0 TO 8)
DIM SHARED elbuf(0 TO 63, 0 TO 8)
DIM SHARED edpos, edrow
DIM SHARED speed
DIM SHARED posjmp, ptnbrk
DIM SHARED vocnte(0 TO 8), vocini(0 TO 8)
DIM SHARED vocvol(0 TO 8), vocfrq(0 TO 8)
DIM SHARED vococt(0 TO 8)
DIM SHARED arpfrq(0 TO 2, 0 TO 8), arpoct(0 TO 2, 0 TO 8)
DIM SHARED flgarp(0 TO 8)
DIM SHARED frqshift(0 TO 8), frqadd(0 TO 8)
DIM SHARED prtsrcfrq(0 TO 8), prtsrco(0 TO 8)
DIM SHARED prtdstfrq(0 TO 8), prtdsto(0 TO 8)
DIM SHARED prtadd(0 TO 8), prtsign(0 TO 8)
DIM SHARED lasteh(0 TO 8), lastel(0 TO 8)


dVocOff:
DATA 0,1,2,8,9,10,16,17,18

dFrqTab:
DATA &H157,&H16B,&H181,&H198,&H1B0,&H1CA
DATA &H1E5,&H202,&H220,&H241,&H263,&H287

dSilence:
DATA &H3F, &H3F, &H0F, &H0F, &H0F, &H0F

PRINT "OOPS! Perhaps You forgot to set the main module?"
END

BT.Play:
count = count + 1
IF count = speed THEN
	DEF SEG = emsseg
	FOR v = 0 TO 8
		n = nbuf(edrow, v)
		o = obuf(edrow, v)
		i = ibuf(edrow, v)
		eh = ehbuf(edrow, v)
		el = elbuf(edrow, v)
		IF eh = 3 THEN
			IF i THEN
				IF vocini(v) <> i THEN
					opl.setinstr v, ins(i)
					vocini(v) = i
				END IF
				IF vocvol(v) < 63 THEN
					l1 = 64 - (62 * (64 - ins(i).lev1) \ 64)
					l2 = 64 - (62 * (64 - ins(i).lev2) \ 64)
					opl.out &H40 + VocOff(v), l1
					opl.out &H43 + VocOff(v), l2
				END IF
				vocvol(v) = 63
			END IF
			IF n < 12 THEN
				frq = vocfrq(v)
				oct = vococt(v)
				prtsrcfrq(v) = frq
				prtsrco(v) = oct
				prtdstfrq(v) = frqtab(n)
				prtdsto(v) = o
				IF prtdsto(v) < oct THEN
					prtsign(v) = -1
				ELSEIF prtdsto(v) > oct THEN
					prtsign(v) = 1
				ELSE
					IF prtdstfrq(v) < frq THEN
						prtsign(v) = -1
					ELSE
						prtsign(v) = 1
					END IF
				END IF
			END IF
		ELSEIF i THEN
			IF n < 12 THEN
			'n+i
				lastel(v) = -1
				opl.out &HB0 + v, 0
				IF eh <> &HC THEN
					IF vocini(v) <> i THEN
						opl.setinstr v, ins(i)
						vocini(v) = i
                                        ELSEIF vocvol(v) < 63 THEN
                                        'hobby illuminati bug fixed
						l1 = 64 - (62 * (64 - ins(i).lev1) \ 64)
						l2 = 64 - (62 * (64 - ins(i).lev2) \ 64)
						opl.out &H40 + VocOff(v), l1
						opl.out &H43 + VocOff(v), l2
					END IF
					vocvol(v) = 63
				ELSE
					IF vocini(v) <> i THEN
						opl.setinstr v, ins(i)
						vocini(v) = i
					END IF
					l1 = 62 - (el * (64 - ins(i).lev1) \ 64)
					l2 = 62 - (el * (64 - ins(i).lev2) \ 64)
					opl.out &H40 + VocOff(v), l1
					opl.out &H43 + VocOff(v), l2
					vocvol(v) = el
				END IF
				frq = frqtab(n)
				opl.out &HA0 + v, frq
				opl.out &HB0 + v, 32 OR (4 * o) OR (frq \ 256)
				vocnte(v) = n
				vococt(v) = o
				vocfrq(v) = frq
			ELSE
			'i
				IF vocini(v) <> i THEN
					opl.setinstr v, ins(i)
					vocini(v) = i
					IF eh = &HC THEN
						l1 = 62 - (el * (64 - ins(i).lev1) \ 64)
						l2 = 62 - (el * (64 - ins(i).lev2) \ 64)
						opl.out &H40 + VocOff(v), l1
						opl.out &H43 + VocOff(v), l2
						vocvol(v) = el
					ELSEIF vocvol(v) < 63 THEN
						l1 = 64 - (vocvol(v) * (64 - ins(i).lev1) \ 64)
						l2 = 64 - (vocvol(v) * (64 - ins(i).lev2) \ 64)
						opl.out &H40 + VocOff(v), l1
						opl.out &H43 + VocOff(v), l2
					END IF
				END IF
				IF lastel(v) THEN
					IF lasteh(v) = 0 THEN
						frq = vocfrq(v)
						opl.out &HA0 + v, frq
						opl.out &HB0 + v, 32 OR (4 * vococt(v)) OR (frq \ 256)
					END IF
				END IF
			END IF
		ELSE
			IF n < 12 THEN
			'n
				lastel(v) = -1
				IF eh = &HC THEN
					ti = vocini(v)
					IF ti >= 0 THEN
						l1 = 62 - (el * (64 - ins(ti).lev1) \ 64)
						l2 = 62 - (el * (64 - ins(ti).lev2) \ 64)
						opl.out &H40 + VocOff(v), l1
						opl.out &H43 + VocOff(v), l2
						vocvol(v) = el
					END IF
				ELSEIF vocvol(v) < 63 THEN
					ti = vocini(v)
					IF ti >= 0 THEN
						l1 = 64 - (vocvol(v) * (64 - ins(ti).lev1) \ 64)
						l2 = 64 - (vocvol(v) * (64 - ins(ti).lev2) \ 64)
						opl.out &H40 + VocOff(v), l1
						opl.out &H43 + VocOff(v), l2
					END IF
				END IF
				frq = frqtab(n)
				opl.out &HA0 + v, frq
				opl.out &HB0 + v, 32 OR (4 * o) OR (frq \ 256)
				vocnte(v) = n
				vococt(v) = o
				vocfrq(v) = frq
			ELSE
			'e?
				IF eh = &HC THEN
					ti = vocini(v)
					IF ti >= 0 THEN
						l1 = 62 - (el * (64 - ins(ti).lev1) \ 64)
						l2 = 62 - (el * (64 - ins(ti).lev2) \ 64)
						opl.out &H40 + VocOff(v), l1
						opl.out &H43 + VocOff(v), l2
						vocvol(v) = el
					END IF
				END IF
				IF lastel(v) THEN
					IF lasteh(v) = 0 THEN
						frq = vocfrq(v)
						opl.out &HA0 + v, frq
						opl.out &HB0 + v, 32 OR (4 * vococt(v)) OR (frq \ 256)
					END IF
				END IF
			END IF
		END IF

		SELECT CASE eh
		CASE 0:
			IF el THEN
				IF el <> lastel(v) THEN
					n = vocnte(v)
					o = vococt(v)
					arpfrq(0, v) = frqtab(n)
					arpoct(0, v) = o
					an1 = n + (el \ 16)
					an2 = n + (el AND 15)
					IF an1 < 12 THEN
						arpfrq(1, v) = frqtab(an1)
						arpoct(1, v) = o
					ELSE
						arpfrq(1, v) = frqtab(an1 - 12)
						arpoct(1, v) = o + 1
					END IF
					IF an2 < 12 THEN
						arpfrq(2, v) = frqtab(an2)
						arpoct(2, v) = o
					ELSE
						arpfrq(2, v) = frqtab(an2 - 12)
						arpoct(2, v) = o + 1
					END IF
				END IF
				flgarp(v) = 1
			ELSE
				flgarp(v) = 0
			END IF
			frqadd(v) = 0
			prtadd(v) = 0
		CASE &H1:
			prtadd(v) = 0
			flgarp(v) = 0
			frqadd(v) = el
		CASE &H2:
			prtadd(v) = 0
			flgarp(v) = 0
			frqadd(v) = -el
		CASE &H3:
			frqadd(v) = 0
			flgarp(v) = 0
			prtadd(v) = el
		CASE &HB:
			frqadd(v) = 0
			prtadd(v) = 0
			flgarp(v) = 0
			posjmp = el
		CASE &HD:
			frqadd(v) = 0
			prtadd(v) = 0
			flgarp(v) = 0
			ptnbrk = el
		CASE &HF:
			frqadd(v) = 0
			prtadd(v) = 0
			flgarp(v) = 0
			speed = el
		CASE &HE:
			SELECT CASE (el \ 16)
			CASE 6:
				IF e6x = 0 THEN
					IF ((el AND 15) = 0) THEN
						e6xrow = edrow
					ELSE
						e6xcount = el AND 15
						e6x = 1
					END IF
				END IF
				IF e6x = 1 THEN
					IF ((el AND 15) > 0) THEN
						e6xcount = e6xcount - 1
						IF e6xcount >= 0 THEN
							edrow = e6xrow - 1
						ELSE
							e6x = 0
						END IF
					END IF
				END IF
			CASE &HA:
				ti = vocini(v)
				IF ti >= 0 THEN
					lol = vocvol(v) + (el AND 15)
					IF lol > 63 THEN lol = 63
					l1 = 64 - (lol * (64 - ins(ti).lev1) \ 64)
					l2 = 64 - (lol * (64 - ins(ti).lev2) \ 64)
					opl.out &H40 + VocOff(v), l1
					opl.out &H43 + VocOff(v), l2
					vocvol(v) = lol
				END IF
			CASE &HB:
				ti = vocini(v)
				IF ti >= 0 THEN
					lol = vocvol(v) - (el AND 15)
					IF lol < 2 THEN lol = 2
					l1 = 64 - (lol * (64 - ins(ti).lev1) \ 64)
					l2 = 64 - (lol * (64 - ins(ti).lev2) \ 64)
					opl.out &H40 + VocOff(v), l1
					opl.out &H43 + VocOff(v), l2
					vocvol(v) = lol
				END IF
			END SELECT
			frqadd(v) = 0
			prtadd(v) = 0
			flgarp(v) = 0
		END SELECT
		lasteh(v) = eh
		lastel(v) = el
	NEXT v
	opos = edpos
	IF posjmp >= 0 THEN
		edpos = posjmp
		IF ptnbrk = -1 THEN
			edrow = 0
		ELSE
			edrow = ptnbrk
			ptnbrk = -1
		END IF
		posjmp = -1
	ELSEIF ptnbrk >= 0 THEN
		edpos = edpos + 1
		IF edpos = length THEN edpos = 0
		edrow = ptnbrk
		ptnbrk = -1
	ELSE
		edrow = edrow + 1
		IF edrow = 64 THEN
			edpos = edpos + 1
			IF edpos = length THEN edpos = 0
			edrow = 0
		END IF
	END IF
	IF edpos <> opos THEN
		modptr(0) = 320& * ord(0, edpos)
		modptr(1) = 320& * ord(1, edpos)
		modptr(2) = 320& * ord(2, edpos)
		modptr(3) = 320& * ord(3, edpos)
		modptr(4) = 320& * ord(4, edpos)
		modptr(5) = 320& * ord(5, edpos)
		modptr(6) = 320& * ord(6, edpos)
		modptr(7) = 320& * ord(7, edpos)
		modptr(8) = 320& * ord(8, edpos)
		FOR v = 0 TO 8
			mptr = modptr(v)
			FOR r = 0 TO 63
				nbuf(r, v) = PEEK(mptr): mptr = mptr + 1
				obuf(r, v) = PEEK(mptr): mptr = mptr + 1
				ibuf(r, v) = PEEK(mptr): mptr = mptr + 1
				ehbuf(r, v) = PEEK(mptr): mptr = mptr + 1
				elbuf(r, v) = PEEK(mptr): mptr = mptr + 1
			NEXT r
		NEXT v
	END IF
	count = 0
ELSE
	arpi = arpi + 1
	IF arpi = 3 THEN arpi = 0
	FOR v = 0 TO 8
		IF frqadd(v) THEN
			vocfrq(v) = vocfrq(v) + frqadd(v)
			frq = vocfrq(v)
			opl.out &HA0 + v, frq
			opl.out &HB0 + v, 32 OR (4 * vococt(v)) OR (frq \ 256)
		ELSEIF prtadd(v) THEN
			frq = vocfrq(v)
			oct = vococt(v)
		 
			IF prtsign(v) = 1 THEN
				frq = frq + prtadd(v)
				IF oct = prtdsto(v) THEN
					IF frq > prtdstfrq(v) THEN
						frq = prtdstfrq(v)
						prtadd(v) = 0
					END IF
				END IF
				IF frq > &H287 THEN
					frq = &H143 + (frq - &H287)
					oct = oct + 1
				END IF
			ELSE
				frq = frq - prtadd(v)
				IF oct = prtdsto(v) THEN
					IF frq < prtdstfrq(v) THEN
						frq = prtdstfrq(v)
						prtadd(v) = 0
					END IF
				END IF
				IF frq < &H157 THEN
					frq = &H2AE - (&H157 - frq)
					oct = oct - 1
				END IF
			END IF
			opl.out &HA0 + v, frq
			opl.out &HB0 + v, 32 OR (4 * oct) OR (frq \ 256)
			vocfrq(v) = frq
			vococt(v) = oct
		ELSEIF flgarp(v) THEN
			frq = arpfrq(arpi, v)
			opl.out &HA0 + v, frq
			opl.out &HB0 + v, 32 OR (4 * arpoct(arpi, v)) OR (frq \ 256)
		END IF
	NEXT v
END IF
RETURN

FUNCTION ems.allocpages (npages)
	regs.ax = &H4300
	regs.bx = npages
	INTERRUPT &H67, regs, regs
	ems.allocpages = regs.dx
	ems.status = regs.ax \ 256
END FUNCTION

SUB ems.freepages (handle)
	regs.ax = &H4500
	regs.dx = handle
	INTERRUPT &H67, regs, regs
	ems.status = regs.ax \ 256
END SUB

SUB ems.mappage (phy, lgc, handle)
	regs.ax = &H4400 OR phy
	regs.bx = lgc
	regs.dx = handle
	INTERRUPT &H67, regs, regs
	ems.status = regs.ax \ 256
END SUB

FUNCTION ems.pageframe
	regs.ax = &H4100
	INTERRUPT &H67, regs, regs
	ems.pageframe = regs.bx
	ems.status = regs.ax \ 256
END FUNCTION

SUB eraseins (ini)
	ins(ini).mul1 = 0: ins(ini).mul2 = 0
	ins(ini).lev1 = 0: ins(ini).lev2 = 0
	ins(ini).atd1 = 0: ins(ini).atd2 = 0
	ins(ini).sur1 = 0: ins(ini).sur2 = 0
	ins(ini).wav1 = 0: ins(ini).wav2 = 0
	ins(ini).fbcon = 0
END SUB

SUB eraseptn (ptn)
	DIM ofs AS LONG

	DEF SEG = emsseg
	ofs = 320& * ptn
	FOR r = 0 TO 63
		POKE ofs, 12: ofs = ofs + 1
		POKE ofs, 0: ofs = ofs + 1
		POKE ofs, 0: ofs = ofs + 1
		POKE ofs, 0: ofs = ofs + 1
		POKE ofs, 0: ofs = ofs + 1
	NEXT r
END SUB

FUNCTION InstallPlayer
	emsh = ems.allocpages(4)
	IF ems.status THEN
		PRINT "EMS allocation problem."
		InstallPlayer = 0
		EXIT FUNCTION
	END IF
	ems.mappage 0, 0, emsh
	ems.mappage 1, 1, emsh
	ems.mappage 2, 2, emsh
	ems.mappage 3, 3, emsh
	IF ems.status THEN
		PRINT "EMS mapping problem."
		ems.freepages emsh
		InstallPlayer = 0
		EXIT FUNCTION
	END IF
	emsseg = ems.pageframe
	RESTORE dVocOff
	FOR a = 0 TO 8: READ VocOff(a): NEXT a
	RESTORE dFrqTab
	FOR a = 0 TO 11: READ frqtab(a): NEXT a
	RESTORE dSilence
	READ ins(32).lev1, ins(32).lev2
	READ ins(32).atd1, ins(32).atd2
	READ ins(32).sur1, ins(32).sur2
	InstallPlayer = 1
END FUNCTION

SUB loadmod (filenm$)
	OPEN filenm$ FOR BINARY ACCESS READ AS #1
	length = readb(1)
	nptns = readb(1)
	ninstrs = readb(1)
	IF (nptns = 0) OR (nptns > 204) OR (ninstrs > 31) THEN CLOSE #1: EXIT SUB
	DIM ptnmap(0 TO nptns - 1)
	FOR a = 0 TO nptns - 1
		ptnmap(a) = readb(1)
		IF ptnmap(a) > 203 THEN CLOSE #1: EXIT SUB
	NEXT a
	IF ninstrs THEN
		DIM insmap(0 TO ninstrs - 1)
		FOR a = 0 TO ninstrs - 1
			insmap(a) = readb(1)
			IF (insmap(a) < 1) OR (insmap(a) > 31) THEN CLOSE #1: EXIT SUB
		NEXT a
	END IF
	FOR p = 0 TO 203
		eraseptn p
	NEXT p
	FOR i = 1 TO 31
		eraseins i
	NEXT i
	FOR p = 0 TO length - 1
		FOR v = 0 TO 8
			ord(v, p) = readb(1)
			IF ord(v, p) > 203 THEN CLOSE #1: EXIT SUB
		NEXT v
	NEXT p
	DEF SEG = emsseg
	FOR a = 0 TO nptns - 1
		ptn = ptnmap(a)
		ofs = 320& * ptn
		FOR row = 0 TO 63
			b1 = readb(1)
			b2 = readb(1)
			el = readb(1)
			n = b1 \ 16
			o = (b1 \ 2) AND 7
			i = (16 * (b1 AND 1)) OR (b2 \ 16)
			eh = b2 AND 15
			POKE ofs, n: ofs = ofs + 1
			POKE ofs, o: ofs = ofs + 1
			POKE ofs, i: ofs = ofs + 1
			POKE ofs, eh: ofs = ofs + 1
			POKE ofs, el: ofs = ofs + 1
		NEXT row
	NEXT a
	IF ninstrs THEN
		FOR a = 0 TO ninstrs - 1
			ini = insmap(a)
			ins(ini).mul1 = readb(1)
			ins(ini).mul2 = readb(1)
			ins(ini).lev1 = readb(1)
			ins(ini).lev2 = readb(1)
			ins(ini).atd1 = readb(1)
			ins(ini).atd2 = readb(1)
			ins(ini).sur1 = readb(1)
			ins(ini).sur2 = readb(1)
			ins(ini).wav1 = readb(1)
			ins(ini).wav2 = readb(1)
			ins(ini).fbcon = readb(1)
		NEXT a
	END IF
	CLOSE #1
	modptr(0) = 320& * ord(0, edpos)
	modptr(1) = 320& * ord(1, edpos)
	modptr(2) = 320& * ord(2, edpos)
	modptr(3) = 320& * ord(3, edpos)
	modptr(4) = 320& * ord(4, edpos)
	modptr(5) = 320& * ord(5, edpos)
	modptr(6) = 320& * ord(6, edpos)
	modptr(7) = 320& * ord(7, edpos)
	modptr(8) = 320& * ord(8, edpos)
	FOR v = 0 TO 8
		mptr = modptr(v)
		FOR r = 0 TO 63
			nbuf(r, v) = PEEK(mptr): mptr = mptr + 1
			obuf(r, v) = PEEK(mptr): mptr = mptr + 1
			ibuf(r, v) = PEEK(mptr): mptr = mptr + 1
			ehbuf(r, v) = PEEK(mptr): mptr = mptr + 1
			elbuf(r, v) = PEEK(mptr): mptr = mptr + 1
		NEXT r
	NEXT v
	speed = 6: edpos = 0: edrow = 0
END SUB

SUB opl.out (reg, vlu)
	OUT &H388, reg
	a = INP(&H388)
	OUT &H389, vlu
	a = INP(&H388)
	a = INP(&H388)
	a = INP(&H388)
END SUB

SUB opl.setinstr (v, i AS Instrument)
	reg = &H20 + VocOff(v)
	opl.out reg, i.mul1: reg = reg + 3
	opl.out reg, i.mul2: reg = reg + &H1D
	opl.out reg, i.lev1: reg = reg + 3
	opl.out reg, i.lev2: reg = reg + &H1D
	opl.out reg, i.atd1: reg = reg + 3
	opl.out reg, i.atd2: reg = reg + &H1D
	opl.out reg, i.sur1: reg = reg + 3
	opl.out reg, i.sur2: reg = reg + &H5D
	opl.out reg, i.wav1: reg = reg + 3
	opl.out reg, i.wav2: reg = reg + &H1D
	opl.out &HC0 + v, i.fbcon
END SUB

SUB PlayMod (position, row)
	edpos = position
	edrow = row
	FOR v = 0 TO 8
		vocini(v) = -1
		modptr(v) = (320& * ord(v, edpos)) + (5 * edrow)
	NEXT v
	posjmp = -1
	ptnbrk = -1
	e6 = 0
	ON TIMER(1) GOSUB BT.Play
	TIMER ON
	settimerfrq 911
END SUB

FUNCTION readb (fh)
	b$ = CHR$(0)
	GET fh, , b$
	readb = ASC(b$)
END FUNCTION

SUB RemovePlayer
	ems.freepages emsh
END SUB

SUB settimerfrq (hz)
	OUT &H43, &H34
	IF hz = 0 THEN
		OUT &H40, 0
		OUT &H40, 0
	ELSE
		count = &H1234DD \ hz
		OUT &H40, count AND 255
		OUT &H40, count \ 256
	END IF
END SUB

SUB StopMod
	settimerfrq 0
	TIMER OFF
	FOR v = 0 TO 8
		opl.setinstr v, ins(32)
		vocini(v) = 32
		opl.out &HB0 + v, 0
	NEXT v
END SUB

