/*********************************************************************
* fasttrak.h
*
*   Copyright (C) 1999-2002	Promise Technology, Inc.
*   May be copied or modified under the terms of the
*   GNU Lesser General Public License
*
*********************************************************************/

#ifndef _fasttrak_h
#define _fasttrak_h

#include <linux/version.h>
// -----------------------------------------------
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,4,0)
#define FASTTRAK {						\
	next: NULL,						\
	proc_dir: NULL, 					\
	proc_info: NULL,    				        \
	name: "FastTrak",					\
	detect: fasttrak_detect,				\
	ioctl: fasttrak_ioctl,					\
	info: NULL,					        \
	command: NULL,						\
	queuecommand: fasttrak_queuecommand,			\
	eh_abort_handler : fasttrak_abort_eh,			\
	eh_device_reset_handler : fasttrak_reset_eh,		\
	abort: fasttrak_abort,					\
	reset: fasttrak_reset,					\
	slave_attach: NULL,					\
	bios_param: fasttrak_bios_param,			\
	can_queue: Can_Queue,	/* max simultaneous cmds      */\
	this_id: 7,		/* scsi id of host adapter    */\
	sg_tablesize: Max_SG_Table,	/* max scatter-gather cmds    */\
	cmd_per_lun: 1,		/* cmds per lun (linked cmds) */\
	present: 0,						\
	unchecked_isa_dma: 0,	/* no memory DMA restrictions */\
	use_clustering: 0,					\
        use_new_eh_code: 0, 	/* enable this field next time*/\
        emulated: 0, 						\
        proc_name: "FastTrak" 					\
} 
#else
#define FASTTRAK {						\
	next: NULL,						\
	proc_dir: NULL, 					\
	proc_info: NULL,    				        \
	name: "FastTrak",					\
	detect: fasttrak_detect,				\
	ioctl: fasttrak_ioctl,					\
	info: NULL,					        \
	command: NULL,						\
	queuecommand: fasttrak_queuecommand,			\
	eh_abort_handler : fasttrak_abort_eh,			\
	eh_device_reset_handler : fasttrak_reset_eh,		\
	abort: fasttrak_abort,					\
	reset: fasttrak_reset,					\
	slave_attach: NULL,					\
	bios_param: fasttrak_bios_param,			\
	can_queue: Can_Queue,	/* max simultaneous cmds      */\
	this_id: 7,		/* scsi id of host adapter    */\
	sg_tablesize: Max_SG_Table,	/* max scatter-gather cmds    */\
	cmd_per_lun: 1,		/* cmds per lun (linked cmds) */\
	present: 0,						\
	unchecked_isa_dma: 0,	/* no memory DMA restrictions */\
	use_clustering: 0,					\
        use_new_eh_code: 0, 	/* enable this field next time*/\
        emulated: 0, 						\
} 
#endif
// -----------------------------------------------

#endif /* _fasttrak_h */ 
