/*********************************************************************
  wrapper.c

  Copyright (C) 1999-2003	Promise Technology, Inc.
  May be copied or modified under the terms of the
  GNU Lesser General Public License

*********************************************************************/
 
#include <asm/io.h>
#include <asm/ptrace.h>
#include <linux/delay.h>
#include <linux/sched.h>
#include <linux/types.h>
//#include <linux/malloc.h>
#include <linux/blk.h>
#include <linux/pci.h>

/* used same as list_head in linux kernel */
struct 	ft_list_head {
	struct ft_list_head *next, *prev;
};

/* used same as timer_list in linux kernel */
struct 	ft_timer_list {
	struct ft_list_head list;
	unsigned long expires;
	unsigned long data;
	void (*function)(unsigned long);
};

extern void ft_handler(int irq, void *dev_id);

unchar ft_inb (ushort port) {
  	return inb(port);
}

unsigned ft_inw (ushort port) {
	return inw(port);
}

void ft_outb (unchar value, ushort port) {
  	outb(value, port);
}

void ft_outw (ushort value, ushort port) {
	outw(value, port);
}

void ft_outl (ulong value, ushort port) {
  	outl(value, port);
}

//int ft_printk(const char *fmt, ...) {
int ft_printk(const unsigned char *fmt, va_list *argp) {
 	return printk(fmt, argp);
}

//extern int sprintf(char * buf, const char * fmt, ...);
int ft_sprintf(char * buf, const char * fmt, va_list *argp) {
	return sprintf(buf, fmt, argp);
}

void ft_init_timer(struct ft_timer_list * timer) {
/* If necessary convert ft_timer_list into timer_list */
  	init_timer((struct timer_list *)timer);
}

void ft_add_timer(struct ft_timer_list * timer) {
/* If necessary convert ft_timer_list into timer_list */
  	add_timer((struct timer_list *)timer);
}

void ft_del_timer(struct ft_timer_list * timer) {
/* If necessary convert ft_timer_list into timer_list */
  	del_timer((struct timer_list *)timer);
}
  
void ft_udelay(unsigned long usecs) {
  	udelay(usecs);
}

void ft_mdelay(unsigned long usecs) {
  	mdelay(usecs);
}

unsigned long volatile ft_get_jiffies(void) {
/* jiffies is the number of clock ticks since the OS was booted */
/* it is exported by the linux kernel */
  	return jiffies;
}

void ft_handler_wrapper(int irq, void *dev_id, struct pt_regs *regs) {
   	/* channel driver is system independent so it does not
      	   need pt_regs structure */
	ulong	smpflag;
   	spin_lock_irqsave(&io_request_lock,smpflag);
   	ft_handler(irq, dev_id);
   	spin_unlock_irqrestore(&io_request_lock,smpflag);
}

void ft_do_gettimeofday(struct timeval *tv) {
	do_gettimeofday(tv);
}

void *ft_ioremap( unsigned long phys_address , unsigned long size){

	return ioremap( phys_address, size ); 
}

void ft_iounmap( void *mem_address ){

	iounmap( mem_address );

	return;
}

int ft_pci_read_config_word( struct pci_dev *dev, int where, u16 *val ){

	return pci_read_config_word( dev, where, val );
}

int ft_pci_write_config_word( struct pci_dev *dev, int where, u16 val ){

	return pci_write_config_word( dev, where, val );

}

int ft_vsprintf( char *buf, const char *str , va_list list){
	return vsprintf( buf, str, list );
}

