/*****************************************************************************
 *****************************************************************************
 Copyright (c) 1999 - 2000, Intel Corporation 

 All rights reserved.

 Redistribution and use in source and binary forms, with or without 
 modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice, 
    this list of conditions and the following disclaimer.

 2. Redistributions in binary form must reproduce the above copyright notice,
    this list of conditions and the following disclaimer in the documentation 
    and/or other materials provided with the distribution.

 3. Neither the name of Intel Corporation nor the names of its contributors 
    may be used to endorse or promote products derived from this software 
    without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 DISCLAIMED. IN NO EVENT SHALL CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 

 *****************************************************************************
 ****************************************************************************/

 /***************************************************************************
 **                                                                        **
 ** INTEL CORPORATION                                                      **
 **                                                                        **
 ** This software is supplied under the terms of the license included      **
 ** above.  All use of this software must be in accordance with the terms  **
 ** of that license.                                                       **
 **                                                                        **
 **  THIS FILE IS INCLUDED BY ians_core.o. HENCE, IT SHOULD NOT BE         **
 **  MODIFIED!                                                             **
 **                                                                        **
 **  Module Name:                                                          **
 **    incg_utils.h                                                        **
 **                                                                        **
 **  Abstract:                                                             **
 **    iANS implimentation of some kernel utilities.                       **
 **                                                                        **
 **  Environment:                                                          **
 **    Kernel Mode (linux 2.2.x)                                           **
 **                                                                        **
 ***************************************************************************/




#ifndef _IANS_UTILS_H
#define _IANS_UTILS_H


#include "incg_defs.h"
#include "incg_flow.h"
#include "pubDefs.h"


#define	INGC_EMERG_LEVEL   0	/* system is unusable */
#define	INGC_ALERT_LEVEL   1	/* action must be taken immediately */
#define	INGC_CRIT_LEVEL    2	/* critical conditions */
#define	INGC_ERR_LEVEL     3	/* error conditions condition */
#define	INGC_WARNING_LEVEL 4	/* warning conditions	 */
#define	INGC_NOTICE_LEVEL  5	/* normal but significant condition */
#define	INGC_INFO_LEVEL    6	/* informational			*/
#define	INGC_DEBUG_LEVEL   7	/* debug-level messages			*/
#define	INGC_NO_LEVEL      8


#define IANS_ERROR(msg) { iAnsKernelPrint ( 3 , msg ); }


void iAnsKernelPrint (int level, char* fmt, ...);

void iAnsPanic(const char * fmt, ...);

int iAnsWaitUsec ( int delayUsec_p ); // wait and busy and not sleep

char * iAnsStrCpy(char * dest, const char * src);

char*  iAnsStrNCpy(char * dest, const char * src, int len);

int    iAnsStrCmp(const char * dest, const char * src);

int    iAnsStrNCmp(const char * dest, const char * src, int len);

int    iAnsStrLen(const char * str);

int iAnsItoa(int value,char* res);

void iAnsUltoa(unsigned long value, char string[], int radix);

void iAnsStringPadCopy(const char *pSrc,char *pDst,const UINT16	MaxLen);

void  iAnsMemCpy(void * dest, const void * src, SIZE_T len);

char * iAnsStringAllocCopy(CONST char *pSrc);

void iAnsStringFree(char * pStr);

int iAnsLog2(int x);


#endif
