/*****************************************************************************
 *****************************************************************************
 Copyright (c) 1999 - 2000, Intel Corporation 

 All rights reserved.

 Redistribution and use in source and binary forms, with or without 
 modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice, 
    this list of conditions and the following disclaimer.

 2. Redistributions in binary form must reproduce the above copyright notice,
    this list of conditions and the following disclaimer in the documentation 
    and/or other materials provided with the distribution.

 3. Neither the name of Intel Corporation nor the names of its contributors 
    may be used to endorse or promote products derived from this software 
    without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 DISCLAIMED. IN NO EVENT SHALL CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 

 *****************************************************************************
 ****************************************************************************/

 /***************************************************************************
 **                                                                        **
 ** INTEL CORPORATION                                                      **
 **                                                                        **
 ** This software is supplied under the terms of the license included      **
 ** above.  All use of this software must be in accordance with the terms  **
 ** of that license.                                                       **
 **                                                                        **
 **  Module Name:                                                          **
 **    incg_utils.c                                                        **
 **                                                                        **
 **  Abstract:                                                             **
 **    iANS implimentation of some kernel utilities.                       **
 **                                                                        **
 **  Environment:                                                          **
 **    Kernel Mode (linux 2.2.x)                                           **
 **                                                                        **
 ***************************************************************************/

//must allways stay the first lines in the file!
#ifdef MODVERSIONS
#include <linux/modversions.h>
#endif MODVERSIONS

#include <linux/malloc.h>
#include <linux/kernel.h>
//#include <linux/socket.h>
//#include <linux/if.h>
//#include <linux/ioctl.h>
//#include <linux/netdevice.h>
#include <linux/string.h>

#include "incg_utils.h"
#include "incg_debug.h"
#include "incg_defs.h"


// write a log messgae to the kernel.
// tranform the messgae level to the appropriate kernel level.
// WRITTEN BY NOAM
void iAnsKernelPrint (int level, char* fmt, ...) 
{
  /*
  static char* ansDebugLevel2KernelLevel[] = 
  { KERN_EMERG,KERN_ALERT,KERN_CRIT,KERN_ERR,KERN_WARNING,KERN_NOTICE,
    KERN_INFO,KERN_DEBUG};

    printk( ansDebugLevel2KernelLevel[0] "%s", message_buffer);
  */


  static char message_buffer[1024];

  va_list args; 
  va_start(args, fmt); 
  vsprintf(message_buffer, fmt, args);
  va_end(args); 


  switch (level) {
    case 0: printk(KERN_EMERG  "%s", message_buffer);
      break;
    case 1: printk(KERN_ALERT  "%s", message_buffer);
      break;
    case 2: printk(KERN_CRIT   "%s", message_buffer);
      break;
    case 3: printk(KERN_ERR    "%s", message_buffer);
      break;
    case 4: printk(KERN_WARNING "%s", message_buffer);
      break;
    case 5: printk(KERN_NOTICE  "%s", message_buffer);
      break;
    case 6: printk(KERN_INFO    "%s", message_buffer);
      break;
    case 7: printk(KERN_DEBUG    "%s", message_buffer);
      break;
	case 8: printk("%s",message_buffer);
      break;
    default: printk(KERN_ERR     "%s", "invalid iAnsKernelPrint level" );
      break;
    }
}



void iAnsPanic(const char * fmt, ...)
{

  static char buf[1024];

  va_list args; 
  va_start(args, fmt); 
  vsprintf(buf, fmt, args);
  va_end(args); 

  panic(buf);
}


// wait and busy and not sleep
int iAnsWaitUsec ( int delayUsec_p ) 
{
  // ??? noam. to be filled with a kernel delay function. 
  return 0;
  ;
}


char * iAnsStrCpy(char * dest, const char * src)
{
     return (strcpy(dest,src));
}

char * iAnsStrNCpy(char * dest, const char * src, int len)
{
     return (strncpy(dest,src,len));
}

int iAnsStrCmp(const char * dest, const char * src)
{
  return (strcmp(dest,src));
}

int iAnsStrNCmp(const char * dest, const char * src,const int len)
{
  return (strncmp(dest,src,len));
}

int iAnsStrLen(const char * string)
{
  return (strlen(string));
}


int iAnsItoa(int value,char* res) {
	ASSERT(res);

	sprintf(res,"%d",value);
	return IANS_OK;
}


void iAnsUltoa(unsigned long value, char string[], int radix)
{
	int i, len;
	char tmp_buffer[MAX_ARG_LENGTH];

	i=0;
	do
	{
		string[i++] = (char)(value % radix) + '0';
	} while ( (value /= radix) > 0);

	string[i++] = '\0';

	// reverse 
        for (len=0; len<i-1 ;len++)
                tmp_buffer[len] = string[i-2-len];
        tmp_buffer[i-1] = '\0';

	// copy to original 
	for (len=0; len<i ;len++)
		 string[len] = tmp_buffer[len];

}




/**
* Copy not more than Len bytes and pad the rest with '\0' 
**/
void iAnsStringPadCopy(const char *pSrc,char *pDst,CONST UINT16	MaxLen){
	
	INT32	LeftLen;

	LeftLen = (INT32)MaxLen;

	// while more to copy 
	while ( ( LeftLen != 0 ) && ( *pSrc != '\0' ) ){
		*(pDst++) = *(pSrc++);
		LeftLen--;
	} // While more to copy 

	// Destination must contain a terminator even if src too long 
	do{
		*(pDst++) = '\0';
		LeftLen--;
	} while ( LeftLen > 0 );

} // iNCGStringPadCopy() 


void  iAnsMemCpy(void * dest, const void * src, SIZE_T len)
{
  memcpy(dest,src,len);
}


/* ------------------------------------------------------------------ */
/* Allocate memory and copy the ASCIIZ string into it */

char * iAnsStringAllocCopy(CONST char *pSrc){
	char *	pDst;
	char *	pTmp;
	INT32	Len; // Must be signed 

	Len = (INT32) strlen( pSrc );

        pDst = kmalloc (Len+1 , GFP_KERNEL );
	
	if ( pDst != NULL ){
		pTmp = pDst;
		while ( Len >= 0 ){
			*(pTmp++) = *(pSrc++);
			Len--;
		} // while more to copy (inc. terminator)
	} // if allocation succeeded 

	return ( pDst );
} // iNCGStringAllocCopy()



/* ------------------------------------------------------------------ */
/* Free ASCIIZ */

void iAnsStringFree(char * pStr){

	UINT16	Len;

	Len = strlen( pStr );

	kfree ( (void *)pStr );
} /* iNCGStringFree() */






/*--------------------------------------------------------------------*
 | iAnsLog2() 
 | gets one integer argument: x
 | returns the integer part of the base 2 logarithm of x. 
 *--------------------------------------------------------------------*/
int iAnsLog2(int x){
	int Retval;
	for(Retval=0;x>1;Retval++)
		x = x/2;
	return Retval;
}





